/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.sequential;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.hadoop.io.Text;

public class BatchVerify
extends Test {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        Random rand = new Random();
        long numWrites = state.getLong("numWrites");
        int maxVerify = Integer.parseInt(props.getProperty("maxVerify", "2000"));
        long numVerify = rand.nextInt(maxVerify - 1) + 1;
        if (numVerify > numWrites / 4L) {
            numVerify = numWrites / 4L;
        }
        Connector conn = env.getConnector();
        try (BatchScanner scanner = conn.createBatchScanner(state.getString("seqTableName"), new Authorizations(), 2);){
            int count = 0;
            List<Range> ranges = new ArrayList();
            while ((long)count < numVerify) {
                long rangeStart = rand.nextInt((int)numWrites);
                long rangeEnd = rangeStart + 99L;
                if (rangeEnd > numWrites - 1L) {
                    rangeEnd = numWrites - 1L;
                }
                count = (int)((long)count + (rangeEnd - rangeStart + 1L));
                ranges.add(new Range(new Text(String.format("%010d", rangeStart)), new Text(String.format("%010d", rangeEnd))));
            }
            if ((ranges = Range.mergeOverlapping(ranges)).size() > 1) {
                Collections.sort(ranges);
            }
            if (count == 0 || ranges.size() == 0) {
                return;
            }
            this.log.debug((Object)String.format("scanning %d rows in the following %d ranges:", count, ranges.size()));
            for (Range range : ranges) {
                this.log.debug((Object)range);
            }
            scanner.setRanges(ranges);
            ArrayList keys = new ArrayList();
            for (Map.Entry entry : scanner) {
                keys.add(entry.getKey());
            }
            this.log.debug((Object)("scan returned " + keys.size() + " rows. now verifying..."));
            Collections.sort(keys);
            Iterator iterator = keys.iterator();
            int curKey = Integer.parseInt(((Key)iterator.next()).getRow().toString());
            boolean done = false;
            block7: for (Range r : ranges) {
                int start = Integer.parseInt(r.getStartKey().getRow().toString());
                int end = Integer.parseInt(String.copyValueOf(r.getEndKey().getRow().toString().toCharArray(), 0, 10));
                for (int i = start; i <= end; ++i) {
                    if (done) {
                        this.log.error((Object)("missing key " + i));
                        continue block7;
                    }
                    while (curKey < i) {
                        this.log.error((Object)("extra key " + curKey));
                        if (!iterator.hasNext()) {
                            done = true;
                            break;
                        }
                        curKey = Integer.parseInt(((Key)iterator.next()).getRow().toString());
                    }
                    if (curKey > i) {
                        this.log.error((Object)("missing key " + i));
                    }
                    if (iterator.hasNext()) {
                        curKey = Integer.parseInt(((Key)iterator.next()).getRow().toString());
                        continue;
                    }
                    done = true;
                }
            }
            this.log.debug((Object)"verify is now complete");
        }
    }
}

