/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.security;

import java.util.Properties;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.security.Authenticate;
import org.apache.accumulo.test.randomwalk.security.WalkingSecurity;
import org.apache.log4j.Logger;

public class Validate
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        Validate.validate(state, env, this.log);
    }

    public static void validate(State state, Environment env, Logger log) throws Exception {
        Authorizations accuAuths;
        Authorizations auths;
        boolean cloudTableUserExists;
        boolean cloudTableExists;
        Connector conn = env.getConnector();
        boolean tableExists = WalkingSecurity.get(state, env).getTableExists();
        if (tableExists != (cloudTableExists = conn.tableOperations().list().contains(WalkingSecurity.get(state, env).getTableName()))) {
            throw new AccumuloException("Table existance out of sync");
        }
        boolean tableUserExists = WalkingSecurity.get(state, env).userExists(WalkingSecurity.get(state, env).getTabUserName());
        if (tableUserExists != (cloudTableUserExists = conn.securityOperations().listLocalUsers().contains(WalkingSecurity.get(state, env).getTabUserName()))) {
            throw new AccumuloException("Table User existance out of sync");
        }
        Properties props = new Properties();
        props.setProperty("target", "system");
        Authenticate.authenticate(env.getUserName(), env.getToken(), state, env, props);
        props.setProperty("target", "table");
        Authenticate.authenticate(env.getUserName(), env.getToken(), state, env, props);
        for (String user : new String[]{WalkingSecurity.get(state, env).getSysUserName(), WalkingSecurity.get(state, env).getTabUserName()}) {
            for (SystemPermission systemPermission : SystemPermission.values()) {
                boolean accuHasSp;
                boolean hasSp = WalkingSecurity.get(state, env).hasSystemPermission(user, systemPermission);
                try {
                    accuHasSp = conn.securityOperations().hasSystemPermission(user, systemPermission);
                    log.debug((Object)("Just checked to see if user " + user + " has system perm " + systemPermission.name() + " with answer " + accuHasSp));
                }
                catch (AccumuloSecurityException ae) {
                    if (ae.getSecurityErrorCode().equals((Object)SecurityErrorCode.USER_DOESNT_EXIST)) {
                        if (!tableUserExists) continue;
                        throw new AccumuloException("Got user DNE error when they should", (Throwable)ae);
                    }
                    throw new AccumuloException("Unexpected exception!", (Throwable)ae);
                }
                if (hasSp == accuHasSp) continue;
                throw new AccumuloException(user + " existance out of sync for system perm " + systemPermission + " hasSp/CloudhasSP " + hasSp + " " + accuHasSp);
            }
            for (SystemPermission systemPermission : TablePermission.values()) {
                boolean accuHasTp;
                boolean hasTp = WalkingSecurity.get(state, env).hasTablePermission(user, WalkingSecurity.get(state, env).getTableName(), (TablePermission)systemPermission);
                try {
                    accuHasTp = conn.securityOperations().hasTablePermission(user, WalkingSecurity.get(state, env).getTableName(), (TablePermission)systemPermission);
                    log.debug((Object)("Just checked to see if user " + user + " has table perm " + systemPermission.name() + " with answer " + accuHasTp));
                }
                catch (AccumuloSecurityException ae) {
                    if (ae.getSecurityErrorCode().equals((Object)SecurityErrorCode.USER_DOESNT_EXIST)) {
                        if (!tableUserExists) continue;
                        throw new AccumuloException("Got user DNE error when they should", (Throwable)ae);
                    }
                    if (ae.getSecurityErrorCode().equals((Object)SecurityErrorCode.TABLE_DOESNT_EXIST)) {
                        if (!tableExists) continue;
                        throw new AccumuloException("Got table DNE when it should", (Throwable)ae);
                    }
                    throw new AccumuloException("Unexpected exception!", (Throwable)ae);
                }
                if (hasTp == accuHasTp) continue;
                throw new AccumuloException(user + " existance out of sync for table perm " + systemPermission + " hasTp/CloudhasTP " + hasTp + " " + accuHasTp);
            }
        }
        try {
            auths = WalkingSecurity.get(state, env).getUserAuthorizations(WalkingSecurity.get(state, env).getTabCredentials());
            accuAuths = conn.securityOperations().getUserAuthorizations(WalkingSecurity.get(state, env).getTabUserName());
        }
        catch (ThriftSecurityException ae) {
            if (ae.getCode() == org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode.USER_DOESNT_EXIST) {
                if (tableUserExists) {
                    throw new AccumuloException("Table user didn't exist when they should.", (Throwable)ae);
                }
                return;
            }
            throw new AccumuloException("Unexpected exception!", (Throwable)ae);
        }
        if (!auths.equals((Object)accuAuths)) {
            throw new AccumuloException("Table User authorizations out of sync");
        }
    }
}

