/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.security;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.security.AlterTable;
import org.apache.accumulo.test.randomwalk.security.AlterTablePerm;
import org.apache.accumulo.test.randomwalk.security.DropTable;
import org.apache.accumulo.test.randomwalk.security.WalkingSecurity;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;

public class TableOp
extends Test {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        conn = env.getInstance().getConnector(WalkingSecurity.get(state, env).getTabUserName(), WalkingSecurity.get(state, env).getTabToken());
        action = props.getProperty("action", "_random");
        if ("_random".equalsIgnoreCase(action)) {
            r = new Random();
            tp = TablePermission.values()[r.nextInt(TablePermission.values().length)];
        } else {
            tp = TablePermission.valueOf((String)action);
        }
        tableExists = WalkingSecurity.get(state, env).getTableExists();
        tableName = WalkingSecurity.get(state, env).getTableName();
        namespaceName = WalkingSecurity.get(state, env).getNamespaceName();
        switch (1.$SwitchMap$org$apache$accumulo$core$security$TablePermission[tp.ordinal()]) {
            case 1: {
                canRead = WalkingSecurity.get(state, env).canScan(WalkingSecurity.get(state, env).getTabCredentials(), tableName, namespaceName);
                auths = WalkingSecurity.get(state, env).getUserAuthorizations(WalkingSecurity.get(state, env).getTabCredentials());
                ambiguousZone = WalkingSecurity.get(state, env).inAmbiguousZone(conn.whoami(), tp);
                ambiguousAuths = WalkingSecurity.get(state, env).ambiguousAuthorizations(conn.whoami());
                scan = null;
                try {
                    scan = conn.createScanner(tableName, conn.securityOperations().getUserAuthorizations(conn.whoami()));
                    seen = 0;
                    for (Object entry : scan) {
                        k = (Key)entry.getKey();
                        ++seen;
                        if (auths.contains(k.getColumnVisibilityData()) || ambiguousAuths) continue;
                        throw new AccumuloException("Got data I should not be capable of seeing: " + k + " table " + tableName);
                    }
                    if (!canRead && !ambiguousZone) {
                        throw new AccumuloException("Was able to read when I shouldn't have had the perm with connection user " + conn.whoami() + " table " + tableName);
                    }
                    for (Map.Entry entry : WalkingSecurity.get(state, env).getAuthsMap().entrySet()) {
                        if (!auths.contains(((String)entry.getKey()).getBytes(StandardCharsets.UTF_8))) continue;
                        seen -= ((Integer)entry.getValue()).intValue();
                    }
                    if (seen != 0 && !ambiguousAuths) {
                        throw new AccumuloException("Got mismatched amounts of data");
                    }
                    break;
                }
                catch (TableNotFoundException tnfe) {
                    if (tableExists) {
                        throw new AccumuloException("Accumulo and test suite out of sync: table " + tableName, (Throwable)tnfe);
                    }
                    return;
                }
                catch (AccumuloSecurityException ae) {
                    if (ae.getSecurityErrorCode().equals((Object)SecurityErrorCode.PERMISSION_DENIED)) {
                        if (canRead && !ambiguousZone) {
                            throw new AccumuloException("Table read permission out of sync with Accumulo: table " + tableName, (Throwable)ae);
                        }
                        return;
                    }
                    if (ae.getSecurityErrorCode().equals((Object)SecurityErrorCode.BAD_AUTHORIZATIONS)) {
                        if (ambiguousAuths) {
                            return;
                        }
                        throw new AccumuloException("Mismatched authorizations! ", (Throwable)ae);
                    }
                    throw new AccumuloException("Unexpected exception!", (Throwable)ae);
                }
                catch (RuntimeException re) {
                    if (re.getCause() instanceof AccumuloSecurityException && ((AccumuloSecurityException)re.getCause()).getSecurityErrorCode().equals((Object)SecurityErrorCode.PERMISSION_DENIED)) {
                        if (canRead && !ambiguousZone) {
                            throw new AccumuloException("Table read permission out of sync with Accumulo: table " + tableName, re.getCause());
                        }
                        return;
                    }
                    if (re.getCause() instanceof AccumuloSecurityException && ((AccumuloSecurityException)re.getCause()).getSecurityErrorCode().equals((Object)SecurityErrorCode.BAD_AUTHORIZATIONS)) {
                        if (ambiguousAuths) {
                            return;
                        }
                        throw new AccumuloException("Mismatched authorizations! ", re.getCause());
                    }
                    throw new AccumuloException("Unexpected exception!", (Throwable)re);
                }
                finally {
                    if (scan != null) {
                        scan.close();
                        scan = null;
                    }
                }
            }
            case 2: {
                canWrite = WalkingSecurity.get(state, env).canWrite(WalkingSecurity.get(state, env).getTabCredentials(), tableName, namespaceName);
                ambiguousZone = WalkingSecurity.get(state, env).inAmbiguousZone(conn.whoami(), tp);
                key = WalkingSecurity.get(state, env).getLastKey() + "1";
                m = new Mutation(new Text(key));
                for (String s : WalkingSecurity.get(state, env).getAuthsArray()) {
                    m.put(new Text(), new Text(), new ColumnVisibility(s), new Value("value".getBytes(StandardCharsets.UTF_8)));
                }
                writer = null;
                try {
                    try {
                        writer = conn.createBatchWriter(tableName, new BatchWriterConfig().setMaxMemory(9000L).setMaxWriteThreads(1));
                    }
                    catch (TableNotFoundException tnfe) {
                        if (tableExists) {
                            throw new AccumuloException("Table didn't exist when it should have: " + tableName);
                        }
                        if (writer != null) {
                            writer.close();
                            writer = null;
                        }
                        return;
                    }
                    works = true;
                    try {
                        writer.addMutation(m);
                        writer.close();
                        ** GOTO lbl106
                    }
                    catch (MutationsRejectedException mre) {
                        if (!canWrite) {
                            if (writer != null) {
                                writer.close();
                                writer = null;
                            }
                            return;
                        }
                        if (ambiguousZone) {
                            Thread.sleep(1000L);
                            try {
                                writer = conn.createBatchWriter(tableName, new BatchWriterConfig().setMaxWriteThreads(1));
                                writer.addMutation(m);
                                writer.close();
                                writer = null;
                            }
                            catch (MutationsRejectedException mre2) {
                                throw new AccumuloException("Mutation exception!", (Throwable)mre2);
                            }
                        }
lbl106:
                        // 4 sources

                        if (works) {
                            for (String s : WalkingSecurity.get(state, env).getAuthsArray()) {
                                WalkingSecurity.get(state, env).increaseAuthMap(s, 1);
                            }
                        }
                        break;
                    }
                }
                finally {
                    if (writer != null) {
                        writer.close();
                        writer = null;
                    }
                }
            }
            case 3: {
                key = WalkingSecurity.get(state, env).getLastKey() + "1";
                keys = new TreeSet<Key>();
                for (String s : WalkingSecurity.get(state, env).getAuthsArray()) {
                    k = new Key((CharSequence)key, (CharSequence)"", (CharSequence)"", (CharSequence)s);
                    keys.add(k);
                }
                dir = new Path("/tmp", "bulk_" + UUID.randomUUID().toString());
                fail = new Path(dir.toString() + "_fail");
                fs = WalkingSecurity.get(state, env).getFs();
                f = FileOperations.getInstance().openWriter(dir + "/securityBulk." + "rf", fs, fs.getConf(), (AccumuloConfiguration)AccumuloConfiguration.getDefaultConfiguration());
                f.startDefaultLocalityGroup();
                fs.mkdirs(fail);
                for (Key k : keys) {
                    f.append(k, new Value("Value".getBytes(StandardCharsets.UTF_8)));
                }
                f.close();
                try {
                    conn.tableOperations().importDirectory(tableName, dir.toString(), fail.toString(), true);
                }
                catch (TableNotFoundException tnfe) {
                    if (tableExists) {
                        throw new AccumuloException("Table didn't exist when it should have: " + tableName);
                    }
                    return;
                }
                catch (AccumuloSecurityException ae) {
                    if (ae.getSecurityErrorCode().equals((Object)SecurityErrorCode.PERMISSION_DENIED)) {
                        if (WalkingSecurity.get(state, env).canBulkImport(WalkingSecurity.get(state, env).getTabCredentials(), tableName, namespaceName)) {
                            throw new AccumuloException("Bulk Import failed when it should have worked: " + tableName);
                        }
                        return;
                    }
                    if (ae.getSecurityErrorCode().equals((Object)SecurityErrorCode.BAD_CREDENTIALS) && WalkingSecurity.get(state, env).userPassTransient(conn.whoami())) {
                        return;
                    }
                    throw new AccumuloException("Unexpected exception!", (Throwable)ae);
                }
                for (String s : WalkingSecurity.get(state, env).getAuthsArray()) {
                    WalkingSecurity.get(state, env).increaseAuthMap(s, 1);
                }
                fs.delete(dir, true);
                fs.delete(fail, true);
                if (WalkingSecurity.get(state, env).canBulkImport(WalkingSecurity.get(state, env).getTabCredentials(), tableName, namespaceName)) break;
                throw new AccumuloException("Bulk Import succeeded when it should have failed: " + dir + " table " + tableName);
            }
            case 4: {
                AlterTable.renameTable(conn, state, env, tableName, tableName + "plus", WalkingSecurity.get(state, env).canAlterTable(WalkingSecurity.get(state, env).getTabCredentials(), tableName, namespaceName), tableExists);
                break;
            }
            case 5: {
                props.setProperty("task", "grant");
                props.setProperty("perm", "random");
                props.setProperty("source", "table");
                props.setProperty("target", "system");
                AlterTablePerm.alter(state, env, props);
                break;
            }
            case 6: {
                props.setProperty("source", "table");
                DropTable.dropTable(state, env, props);
            }
        }
    }
}

