/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.security;

import java.net.InetAddress;
import java.util.Set;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.Fixture;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.security.Validate;
import org.apache.accumulo.test.randomwalk.security.WalkingSecurity;

public class SecurityFixture
extends Fixture {
    @Override
    public void setUp(State state, Environment env) throws Exception {
        Set users;
        ClientConfiguration clientConf = ClientConfiguration.loadDefault();
        if (clientConf.getBoolean(ClientConfiguration.ClientProperty.INSTANCE_RPC_SASL_ENABLED.getKey(), false)) {
            throw new IllegalStateException("Security module currently cannot support Kerberos/SASL instances");
        }
        Connector conn = env.getConnector();
        String hostname = InetAddress.getLocalHost().getHostName().replaceAll("[-.]", "_");
        String systemUserName = String.format("system_%s", hostname);
        String tableUserName = String.format("table_%s", hostname);
        String secTableName = String.format("security_%s", hostname);
        String secNamespaceName = String.format("securityNs_%s", hostname);
        if (conn.tableOperations().exists(secTableName)) {
            conn.tableOperations().delete(secTableName);
        }
        if ((users = conn.securityOperations().listLocalUsers()).contains(tableUserName)) {
            conn.securityOperations().dropLocalUser(tableUserName);
        }
        if (users.contains(systemUserName)) {
            conn.securityOperations().dropLocalUser(systemUserName);
        }
        PasswordToken sysUserPass = new PasswordToken((CharSequence)"sysUser");
        conn.securityOperations().createLocalUser(systemUserName, sysUserPass);
        WalkingSecurity.get(state, env).setTableName(secTableName);
        WalkingSecurity.get(state, env).setNamespaceName(secNamespaceName);
        state.set("rootUserPass", env.getToken());
        WalkingSecurity.get(state, env).setSysUserName(systemUserName);
        WalkingSecurity.get(state, env).createUser(systemUserName, (AuthenticationToken)sysUserPass);
        WalkingSecurity.get(state, env).changePassword(tableUserName, (AuthenticationToken)new PasswordToken(new byte[0]));
        WalkingSecurity.get(state, env).setTabUserName(tableUserName);
        for (TablePermission tablePermission : TablePermission.values()) {
            WalkingSecurity.get(state, env).revokeTablePermission(systemUserName, secTableName, tablePermission);
            WalkingSecurity.get(state, env).revokeTablePermission(tableUserName, secTableName, tablePermission);
        }
        for (TablePermission tablePermission : SystemPermission.values()) {
            WalkingSecurity.get(state, env).revokeSystemPermission(systemUserName, (SystemPermission)tablePermission);
            WalkingSecurity.get(state, env).revokeSystemPermission(tableUserName, (SystemPermission)tablePermission);
        }
        WalkingSecurity.get(state, env).changeAuthorizations(tableUserName, new Authorizations());
    }

    @Override
    public void tearDown(State state, Environment env) throws Exception {
        this.log.debug((Object)"One last validate");
        Validate.validate(state, env, this.log);
        Connector conn = env.getConnector();
        if (WalkingSecurity.get(state, env).getTableExists()) {
            String secTableName = WalkingSecurity.get(state, env).getTableName();
            this.log.debug((Object)("Dropping tables: " + secTableName));
            conn.tableOperations().delete(secTableName);
        }
        if (WalkingSecurity.get(state, env).getNamespaceExists()) {
            String secNamespaceName = WalkingSecurity.get(state, env).getNamespaceName();
            this.log.debug((Object)("Dropping namespace: " + secNamespaceName));
            conn.namespaceOperations().delete(secNamespaceName);
        }
        if (WalkingSecurity.get(state, env).userExists(WalkingSecurity.get(state, env).getTabUserName())) {
            String tableUserName = WalkingSecurity.get(state, env).getTabUserName();
            this.log.debug((Object)("Dropping user: " + tableUserName));
            conn.securityOperations().dropLocalUser(tableUserName);
        }
        String systemUserName = WalkingSecurity.get(state, env).getSysUserName();
        this.log.debug((Object)("Dropping user: " + systemUserName));
        conn.securityOperations().dropLocalUser(systemUserName);
        WalkingSecurity.clearInstance();
        Thread.sleep(2000L);
    }
}

