/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.multitable;

import java.util.ArrayList;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.hadoop.io.Text;

public class CreateTable
extends Test {
    private final TreeSet<Text> splits = new TreeSet();

    public CreateTable() {
        for (int i = 1; i < 10; ++i) {
            this.splits.add(new Text(Integer.toString(i)));
        }
    }

    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        Connector conn = env.getConnector();
        int nextId = (Integer)state.get("nextId");
        String tableName = String.format("%s_%d", state.getString("tableNamePrefix"), nextId);
        try {
            conn.tableOperations().create(tableName);
            conn.tableOperations().addSplits(tableName, this.splits);
            String tableId = (String)Tables.getNameToIdMap((Instance)env.getInstance()).get(tableName);
            this.log.debug((Object)("created " + tableName + " (id:" + tableId + ")"));
            conn.tableOperations().addSplits(tableName, this.splits);
            this.log.debug((Object)("created " + this.splits.size() + " splits on " + tableName));
            ArrayList tables = (ArrayList)state.get("tableList");
            tables.add(tableName);
        }
        catch (TableExistsException e) {
            this.log.warn((Object)("Failed to create " + tableName + " as it already exists"));
        }
        state.set("nextId", ++nextId);
    }
}

