/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.multitable;

import java.io.IOException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.admin.DelegationTokenConfig;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.log4j.Logger;

public class CopyTool
extends Configured
implements Tool {
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

    public int run(String[] args) throws Exception {
        PasswordToken token;
        String principal;
        Job job = Job.getInstance((org.apache.hadoop.conf.Configuration)this.getConf(), (String)((Object)((Object)this)).getClass().getSimpleName());
        job.setJarByClass(((Object)((Object)this)).getClass());
        if (job.getJar() == null) {
            this.log.error((Object)"M/R requires a jar file!  Run mvn package.");
            return 1;
        }
        ClientConfiguration clientConf = new ClientConfiguration(new Configuration[0]).withInstance(args[3]).withZkHosts(args[4]);
        job.setInputFormatClass(AccumuloInputFormat.class);
        AccumuloInputFormat.setInputTableName((Job)job, (String)args[2]);
        AccumuloInputFormat.setScanAuthorizations((Job)job, (Authorizations)Authorizations.EMPTY);
        AccumuloInputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)clientConf);
        if (clientConf.getBoolean(ClientConfiguration.ClientProperty.INSTANCE_RPC_SASL_ENABLED.getKey(), false)) {
            KerberosToken kt = new KerberosToken();
            try {
                UserGroupInformation user = UserGroupInformation.getCurrentUser();
                if (!user.hasKerberosCredentials()) {
                    throw new IllegalStateException("Expected current user to have Kerberos credentials");
                }
                ZooKeeperInstance inst = new ZooKeeperInstance((Configuration)clientConf);
                principal = user.getUserName();
                Connector conn = inst.getConnector(principal, (AuthenticationToken)kt);
                if (!conn.securityOperations().hasSystemPermission(conn.whoami(), SystemPermission.OBTAIN_DELEGATION_TOKEN)) {
                    this.log.error((Object)(principal + " doesn't have the " + SystemPermission.OBTAIN_DELEGATION_TOKEN.name() + " SystemPermission neccesary to obtain a delegation token. MapReduce tasks cannot automatically use the client's" + " credentials on remote servers. Delegation tokens provide a means to run MapReduce without distributing the user's credentials."));
                    throw new IllegalStateException(conn.whoami() + " does not have permission to obtain a delegation token");
                }
                token = conn.securityOperations().getDelegationToken(new DelegationTokenConfig());
            }
            catch (Exception e) {
                String msg = "Failed to acquire DelegationToken for use with MapReduce";
                this.log.error((Object)"Failed to acquire DelegationToken for use with MapReduce", (Throwable)e);
                throw new RuntimeException("Failed to acquire DelegationToken for use with MapReduce", e);
            }
        } else {
            principal = args[0];
            token = new PasswordToken((CharSequence)args[1]);
        }
        AccumuloInputFormat.setConnectorInfo((Job)job, (String)principal, (AuthenticationToken)token);
        AccumuloOutputFormat.setConnectorInfo((Job)job, (String)principal, (AuthenticationToken)token);
        job.setMapperClass(SeqMapClass.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Mutation.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(AccumuloOutputFormat.class);
        AccumuloOutputFormat.setCreateTables((Job)job, (boolean)true);
        AccumuloOutputFormat.setDefaultTableName((Job)job, (String)args[5]);
        AccumuloOutputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)clientConf);
        job.waitForCompletion(true);
        return job.isSuccessful() ? 0 : 1;
    }

    public static class SeqMapClass
    extends Mapper<Key, Value, Text, Mutation> {
        public void map(Key key, Value val, Mapper.Context output) throws IOException, InterruptedException {
            Mutation m = new Mutation(key.getRow());
            m.put(key.getColumnFamily(), key.getColumnQualifier(), val);
            output.write(null, (Object)m);
        }
    }
}

