/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.conditional;

import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.ConditionalWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.data.Condition;
import org.apache.accumulo.core.data.ConditionalMutation;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.conditional.Utils;
import org.apache.commons.math.distribution.ZipfDistributionImpl;
import org.apache.hadoop.io.Text;

public class Transfer
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        String table = state.getString("tableName");
        Random rand = (Random)state.get("rand");
        Connector conn = env.getConnector();
        int numAccts = (Integer)state.get("numAccts");
        ZipfDistributionImpl zdiBanks = new ZipfDistributionImpl(((Integer)state.get("numBanks")).intValue(), 1.0);
        String bank = Utils.getBank(zdiBanks.inverseCumulativeProbability(rand.nextDouble()));
        ZipfDistributionImpl zdiAccts = new ZipfDistributionImpl(numAccts, 1.0);
        String acct1 = Utils.getAccount(zdiAccts.inverseCumulativeProbability(rand.nextDouble()));
        String acct2 = Utils.getAccount(zdiAccts.inverseCumulativeProbability(rand.nextDouble()));
        while (acct2.equals(acct1)) {
            acct2 = Utils.getAccount(rand.nextInt(numAccts));
        }
        IsolatedScanner scanner = new IsolatedScanner(conn.createScanner(table, Authorizations.EMPTY));
        scanner.setRange(new Range((CharSequence)bank));
        scanner.fetchColumnFamily(new Text(acct1));
        scanner.fetchColumnFamily(new Text(acct2));
        Account a1 = new Account();
        Account a2 = new Account();
        for (Map.Entry entry : scanner) {
            Account a;
            String cf = ((Key)entry.getKey()).getColumnFamilyData().toString();
            String cq = ((Key)entry.getKey()).getColumnQualifierData().toString();
            if (cf.equals(acct1)) {
                a = a1;
            } else if (cf.equals(acct2)) {
                a = a2;
            } else {
                throw new Exception("Unexpected column fam: " + cf);
            }
            if (cq.equals("bal")) {
                a.setBal(((Value)entry.getValue()).toString());
                continue;
            }
            if (cq.equals("seq")) {
                a.setSeq(((Value)entry.getValue()).toString());
                continue;
            }
            throw new Exception("Unexpected column qual: " + cq);
        }
        int amt = rand.nextInt(50);
        this.log.debug((Object)("transfer req " + bank + " " + amt + " " + acct1 + " " + a1 + " " + acct2 + " " + a2));
        if (a1.bal >= amt) {
            ConditionalMutation cm = new ConditionalMutation((CharSequence)bank, new Condition[]{new Condition((CharSequence)acct1, (CharSequence)"seq").setValue((CharSequence)Utils.getSeq(a1.seq)), new Condition((CharSequence)acct2, (CharSequence)"seq").setValue((CharSequence)Utils.getSeq(a2.seq))});
            cm.put((CharSequence)acct1, (CharSequence)"bal", (CharSequence)(a1.bal - amt + ""));
            cm.put((CharSequence)acct2, (CharSequence)"bal", (CharSequence)(a2.bal + amt + ""));
            cm.put((CharSequence)acct1, (CharSequence)"seq", (CharSequence)Utils.getSeq(a1.seq + 1));
            cm.put((CharSequence)acct2, (CharSequence)"seq", (CharSequence)Utils.getSeq(a2.seq + 1));
            ConditionalWriter cw = (ConditionalWriter)state.get("cw");
            ConditionalWriter.Status status = cw.write(cm).getStatus();
            while (status == ConditionalWriter.Status.UNKNOWN) {
                this.log.debug((Object)("retrying transfer " + status));
                status = cw.write(cm).getStatus();
            }
            this.log.debug((Object)("transfer result " + bank + " " + status + " " + a1 + " " + a2));
        }
    }

    private static class Account {
        int seq;
        int bal;

        private Account() {
        }

        void setBal(String s) {
            this.bal = Integer.parseInt(s);
        }

        void setSeq(String s) {
            this.seq = Integer.parseInt(s);
        }

        public String toString() {
            return this.seq + " " + this.bal;
        }
    }
}

