/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.server.replication.ReplicaSystemFactory;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.tserver.replication.AccumuloReplicaSystem;
import org.apache.hadoop.io.Text;

public class Replication
extends Test {
    final int ROWS = 1000;
    final int COLS = 50;

    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        String[] tables;
        Connector c = env.getConnector();
        Instance inst = c.getInstance();
        String instName = inst.getInstanceName();
        InstanceOperations iOps = c.instanceOperations();
        TableOperations tOps = c.tableOperations();
        iOps.setProperty(Property.REPLICATION_NAME.getKey(), instName);
        iOps.setProperty(Property.REPLICATION_PEERS.getKey() + instName, ReplicaSystemFactory.getPeerConfigurationValue(AccumuloReplicaSystem.class, (String)(instName + "," + inst.getZooKeepers())));
        iOps.setProperty(Property.REPLICATION_PEER_USER.getKey() + instName, env.getUserName());
        iOps.setProperty(Property.REPLICATION_PEER_PASSWORD.getKey() + instName, env.getPassword());
        iOps.setProperty(Property.MASTER_REPLICATION_SCAN_INTERVAL.getKey(), "1s");
        iOps.setProperty(Property.REPLICATION_WORK_ASSIGNMENT_SLEEP.getKey(), "1s");
        iOps.setProperty(Property.REPLICATION_WORK_PROCESSOR_DELAY.getKey(), "1s");
        iOps.setProperty(Property.REPLICATION_WORK_PROCESSOR_PERIOD.getKey(), "1s");
        ReplicationTable.setOnline((Connector)c);
        boolean online = ReplicationTable.isOnline((Connector)c);
        for (int i = 0; i < 10 && !online; ++i) {
            UtilWaitThread.sleep((long)2000L);
            online = ReplicationTable.isOnline((Connector)c);
        }
        this.assertTrue("Replication table was not online", online);
        String sourceTable = ("repl-source-" + UUID.randomUUID()).replace('-', '_');
        String destTable = ("repl-dest-" + UUID.randomUUID()).replace('-', '_');
        for (String tableName : tables = new String[]{sourceTable, destTable}) {
            this.log.debug((Object)("creating " + tableName));
            tOps.create(tableName);
        }
        String destID = (String)tOps.tableIdMap().get(destTable);
        tOps.setProperty(sourceTable, Property.TABLE_REPLICATION.getKey(), "true");
        tOps.setProperty(sourceTable, Property.TABLE_REPLICATION_TARGET.getKey() + instName, destID);
        UtilWaitThread.sleep((long)5000L);
        Random rand = new Random(System.currentTimeMillis());
        for (String tableName : tables) {
            if (!rand.nextBoolean()) continue;
            this.splitTable(tOps, tableName);
        }
        BatchWriter bw = c.createBatchWriter(sourceTable, null);
        for (int row = 0; row < 1000; ++row) {
            Mutation m = new Mutation((CharSequence)Replication.itos(row));
            for (int col = 0; col < 50; ++col) {
                m.put((CharSequence)"", (CharSequence)Replication.itos(col), (CharSequence)"");
            }
            bw.addMutation(m);
        }
        bw.close();
        Set origRefs = c.replicationOperations().referencedFiles(sourceTable);
        while (true) {
            Set updatedFileRefs = c.replicationOperations().referencedFiles(sourceTable);
            updatedFileRefs.retainAll(origRefs);
            this.log.debug((Object)("updateFileRefs size " + updatedFileRefs.size()));
            if (updatedFileRefs.isEmpty()) break;
            bw = c.createBatchWriter(sourceTable, null);
            for (int row = 0; row < 1000; ++row) {
                Mutation m = new Mutation((CharSequence)Replication.itos(row));
                for (int col = 0; col < 50; ++col) {
                    m.put((CharSequence)"ignored", (CharSequence)Replication.itos(col), (CharSequence)"");
                }
                bw.addMutation(m);
            }
            bw.close();
        }
        UtilWaitThread.sleep((long)30000L);
        Scanner scanner = c.createScanner(destTable, Authorizations.EMPTY);
        scanner.fetchColumnFamily(new Text(""));
        int row = 0;
        int col = 0;
        for (Map.Entry entry : scanner) {
            this.assertEquals(row, Integer.parseInt(((Key)entry.getKey()).getRow().toString()));
            this.assertEquals(col, Integer.parseInt(((Key)entry.getKey()).getColumnQualifier().toString()));
            if (++col != 50) continue;
            ++row;
            col = 0;
        }
        this.assertEquals(1000, row);
        this.assertEquals(0, col);
        for (String tableName : tables) {
            this.log.debug((Object)("Deleting " + tableName));
            tOps.delete(tableName);
        }
    }

    private void assertEquals(int expected, int actual) {
        if (expected != actual) {
            throw new RuntimeException(String.format("%d fails to match expected value %d", actual, expected));
        }
    }

    private void assertTrue(String string, boolean test) {
        if (!test) {
            throw new RuntimeException(string);
        }
    }

    private static String itos(int i) {
        return String.format("%08d", i);
    }

    private void splitTable(TableOperations tOps, String tableName) throws Exception {
        TreeSet<Text> splits = new TreeSet<Text>();
        for (int i = 1; i <= 9; ++i) {
            splits.add(new Text(Replication.itos(i * 100)));
        }
        this.log.debug((Object)("Adding splits to " + tableName));
        tOps.addSplits(tableName, splits);
    }
}

