/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;

public class OfflineTable
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        Connector conn = env.getConnector();
        Random rand = (Random)state.get("rand");
        List tableNames = (List)state.get("tables");
        String tableName = (String)tableNames.get(rand.nextInt(tableNames.size()));
        try {
            conn.tableOperations().offline(tableName, rand.nextBoolean());
            this.log.debug((Object)("Offlined " + tableName));
            UtilWaitThread.sleep((long)rand.nextInt(200));
            conn.tableOperations().online(tableName, rand.nextBoolean());
            this.log.debug((Object)("Onlined " + tableName));
        }
        catch (TableNotFoundException tne) {
            this.log.debug((Object)("offline or online failed " + tableName + ", doesnt exist"));
        }
    }
}

