/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk;

import java.io.File;
import java.util.Properties;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.log4j.Logger;

public abstract class Node {
    protected final Logger log = Logger.getLogger(this.getClass());
    long progress = System.currentTimeMillis();

    public abstract void visit(State var1, Environment var2, Properties var3) throws Exception;

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public String toString() {
        return this.getClass().getName();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public synchronized void makingProgress() {
        this.progress = System.currentTimeMillis();
    }

    public synchronized long lastProgress() {
        return this.progress;
    }

    protected String getMapReduceJars() {
        String acuHome = System.getenv("ACCUMULO_HOME");
        String zkHome = System.getenv("ZOOKEEPER_HOME");
        if (acuHome == null || zkHome == null) {
            throw new RuntimeException("ACCUMULO or ZOOKEEPER home not set!");
        }
        String retval = null;
        File zkLib = new File(zkHome);
        String[] files = zkLib.list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                String f = files[i];
                if (!f.matches("^zookeeper-.+jar$")) continue;
                retval = retval == null ? String.format("%s/%s", zkLib.getAbsolutePath(), f) : retval + String.format(",%s/%s", zkLib.getAbsolutePath(), f);
            }
        }
        File libdir = new File(acuHome + "/lib");
        for (String jar : "accumulo-core accumulo-server-base accumulo-fate accumulo-trace libthrift htrace-core".split(" ")) {
            retval = retval + String.format(",%s/%s.jar", libdir.getAbsolutePath(), jar);
        }
        return retval;
    }
}

