/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environment {
    public static final String KEY_USERNAME = "USERNAME";
    public static final String KEY_PASSWORD = "PASSWORD";
    public static final String KEY_KEYTAB = "KEYTAB";
    public static final String KEY_INSTANCE = "INSTANCE";
    public static final String KEY_ZOOKEEPERS = "ZOOKEEPERS";
    public static final String KEY_MAX_MEM = "MAX_MEM";
    public static final String KEY_MAX_LATENCY = "MAX_LATENCY";
    public static final String KEY_NUM_THREADS = "NUM_THREADS";
    private static final Logger log = LoggerFactory.getLogger(Environment.class);
    private final Properties p;
    private Instance instance = null;
    private Connector connector = null;
    private MultiTableBatchWriter mtbw = null;

    public Environment(Properties p) {
        Objects.requireNonNull(p);
        this.p = p;
    }

    Properties copyConfigProperties() {
        return new Properties(this.p);
    }

    public String getConfigProperty(String key) {
        return this.p.getProperty(key);
    }

    public String getUserName() {
        return this.p.getProperty(KEY_USERNAME);
    }

    public String getPassword() {
        return this.p.getProperty(KEY_PASSWORD);
    }

    public String getKeytab() {
        return this.p.getProperty(KEY_KEYTAB);
    }

    public String getPid() {
        return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }

    public AuthenticationToken getToken() {
        String password = this.getPassword();
        if (null != password) {
            return new PasswordToken((CharSequence)this.getPassword());
        }
        String keytab = this.getKeytab();
        if (null != keytab) {
            File keytabFile = new File(keytab);
            if (!keytabFile.exists() || !keytabFile.isFile()) {
                throw new IllegalArgumentException("Provided keytab is not a normal file: " + keytab);
            }
            try {
                return new KerberosToken(this.getUserName(), keytabFile, true);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to login", e);
            }
        }
        throw new IllegalArgumentException("Must provide password or keytab in configuration");
    }

    public Instance getInstance() {
        if (this.instance == null) {
            String instance = this.p.getProperty(KEY_INSTANCE);
            String zookeepers = this.p.getProperty(KEY_ZOOKEEPERS);
            this.instance = new ZooKeeperInstance((Configuration)ClientConfiguration.loadDefault().withInstance(instance).withZkHosts(zookeepers));
        }
        return this.instance;
    }

    public Connector getConnector() throws AccumuloException, AccumuloSecurityException {
        if (this.connector == null) {
            this.connector = this.getInstance().getConnector(this.getUserName(), this.getToken());
        }
        return this.connector;
    }

    public MultiTableBatchWriter getMultiTableBatchWriter() throws AccumuloException, AccumuloSecurityException {
        if (this.mtbw == null) {
            long maxMem = Long.parseLong(this.p.getProperty(KEY_MAX_MEM));
            long maxLatency = Long.parseLong(this.p.getProperty(KEY_MAX_LATENCY));
            int numThreads = Integer.parseInt(this.p.getProperty(KEY_NUM_THREADS));
            this.mtbw = this.getConnector().createMultiTableBatchWriter(new BatchWriterConfig().setMaxMemory(maxMem).setMaxLatency(maxLatency, TimeUnit.MILLISECONDS).setMaxWriteThreads(numThreads));
        }
        return this.mtbw;
    }

    public boolean isMultiTableBatchWriterInitialized() {
        return this.mtbw != null;
    }

    public void resetMultiTableBatchWriter() {
        if (this.mtbw == null) {
            return;
        }
        if (!this.mtbw.isClosed()) {
            log.warn("Setting non-closed MultiTableBatchWriter to null (leaking resources)");
        }
        this.mtbw = null;
    }
}

