/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.net.HostAndPort;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Random;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.rpc.ServerAddress;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.accumulo.server.rpc.ThriftServerType;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.accumulo.test.performance.thrift.NullTserver;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZombieTServer {
    private static final Logger log = LoggerFactory.getLogger(ZombieTServer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Random random = new Random(System.currentTimeMillis() % 1000L);
        int port = random.nextInt(30000) + 2000;
        AccumuloServerContext context = new AccumuloServerContext(new ServerConfigurationFactory(HdfsZooInstance.getInstance()));
        TransactionWatcher watcher = new TransactionWatcher();
        final ThriftClientHandler tch = new ThriftClientHandler(context, watcher);
        TabletClientService.Processor processor = new TabletClientService.Processor((TabletClientService.Iface)tch);
        ServerAddress serverPort = TServerUtils.startTServer((AccumuloConfiguration)context.getConfiguration(), (HostAndPort)HostAndPort.fromParts((String)"0.0.0.0", (int)port), (ThriftServerType)ThriftServerType.CUSTOM_HS_HA, (TProcessor)processor, (String)"ZombieTServer", (String)"walking dead", (int)2, (int)1, (long)1000L, (long)0xA00000L, null, null, (long)-1L);
        String addressString = serverPort.address.toString();
        String zPath = ZooUtil.getRoot((Instance)context.getInstance()) + "/tservers" + "/" + addressString;
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        zoo.putPersistentData(zPath, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
        ZooLock zlock = new ZooLock(zPath);
        ZooLock.LockWatcher lw = new ZooLock.LockWatcher(){

            public void lostLock(ZooLock.LockLossReason reason) {
                try {
                    tch.halt(Tracer.traceInfo(), null, null);
                }
                catch (Exception ex) {
                    log.error("Exception", (Throwable)ex);
                    System.exit(1);
                }
            }

            public void unableToMonitorLockNode(Throwable e) {
                try {
                    tch.halt(Tracer.traceInfo(), null, null);
                }
                catch (Exception ex) {
                    log.error("Exception", (Throwable)ex);
                    System.exit(1);
                }
            }
        };
        byte[] lockContent = new ServerServices(addressString, ServerServices.Service.TSERV_CLIENT).toString().getBytes(StandardCharsets.UTF_8);
        if (zlock.tryLock(lw, lockContent)) {
            log.debug("Obtained tablet server lock " + zlock.getLockPath());
        }
        ThriftClientHandler thriftClientHandler = tch;
        synchronized (thriftClientHandler) {
            while (!tch.halted) {
                ((Object)((Object)tch)).wait();
            }
        }
        System.exit(0);
    }

    public static class ThriftClientHandler
    extends NullTserver.ThriftClientHandler {
        int statusCount = 0;
        boolean halted = false;

        ThriftClientHandler(AccumuloServerContext context, TransactionWatcher watcher) {
            super(context, watcher);
        }

        @Override
        public synchronized void fastHalt(TInfo tinfo, TCredentials credentials, String lock) {
            this.halted = true;
            ((Object)((Object)this)).notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TabletServerStatus getTabletServerStatus(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
            ThriftClientHandler thriftClientHandler = this;
            synchronized (thriftClientHandler) {
                if (this.statusCount++ < 1) {
                    TabletServerStatus result = new TabletServerStatus();
                    result.tableMap = new HashMap();
                    return result;
                }
            }
            UtilWaitThread.sleep((long)Integer.MAX_VALUE);
            return null;
        }

        @Override
        public synchronized void halt(TInfo tinfo, TCredentials credentials, String lock) throws ThriftSecurityException, TException {
            this.halted = true;
            ((Object)((Object)this)).notifyAll();
        }
    }
}

