/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.accumulo.core.util.UtilWaitThread;

public class SlowIterator
extends WrappingIterator {
    private static final String SLEEP_TIME = "sleepTime";
    private static final String SEEK_SLEEP_TIME = "seekSleepTime";
    private long sleepTime = 0L;
    private long seekSleepTime = 0L;

    public static void setSleepTime(IteratorSetting is, long millis) {
        is.addOption(SLEEP_TIME, Long.toString(millis));
    }

    public static void setSeekSleepTime(IteratorSetting is, long t) {
        is.addOption(SEEK_SLEEP_TIME, Long.toString(t));
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        throw new UnsupportedOperationException();
    }

    public void next() throws IOException {
        UtilWaitThread.sleep((long)this.sleepTime);
        super.next();
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        UtilWaitThread.sleep((long)this.seekSleepTime);
        super.seek(range, columnFamilies, inclusive);
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        if (options.containsKey(SLEEP_TIME)) {
            this.sleepTime = Long.parseLong(options.get(SLEEP_TIME));
        }
        if (options.containsKey(SEEK_SLEEP_TIME)) {
            this.seekSleepTime = Long.parseLong(options.get(SEEK_SLEEP_TIME));
        }
    }
}

