/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;

public class CacheTestWriter {
    static final int NUM_DATA = 3;

    public static void main(String[] args) throws Exception {
        ZooReaderWriter zk = ZooReaderWriter.getInstance();
        String rootDir = args[0];
        File reportDir = new File(args[1]);
        int numReaders = Integer.parseInt(args[2]);
        int numVerifications = Integer.parseInt(args[3]);
        int numData = 3;
        boolean dataSExists = false;
        int count = 0;
        zk.putPersistentData(rootDir, new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
        for (int i = 0; i < numData; ++i) {
            zk.putPersistentData(rootDir + "/data" + i, new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
        }
        zk.putPersistentData(rootDir + "/dir", new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
        ArrayList<String> children = new ArrayList<String>();
        Random r = new Random();
        block3: while (count++ < numVerifications) {
            TreeMap<String, String> expectedData = null;
            for (int u = 0; u < r.nextInt(4) + 1; ++u) {
                expectedData = new TreeMap<String, String>();
                if ((double)r.nextFloat() < 0.5) {
                    String child = UUID.randomUUID().toString();
                    zk.putPersistentData(rootDir + "/dir/" + child, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
                    children.add(child);
                } else if (children.size() > 0) {
                    int index = r.nextInt(children.size());
                    String child = (String)children.remove(index);
                    zk.recursiveDelete(rootDir + "/dir/" + child, ZooUtil.NodeMissingPolicy.FAIL);
                }
                for (String child : children) {
                    expectedData.put(rootDir + "/dir/" + child, "");
                }
                for (int i = 0; i < numData; ++i) {
                    byte[] data = Long.toString(r.nextLong(), 16).getBytes(StandardCharsets.UTF_8);
                    zk.putPersistentData(rootDir + "/data" + i, data, ZooUtil.NodeExistsPolicy.OVERWRITE);
                    expectedData.put(rootDir + "/data" + i, new String(data, StandardCharsets.UTF_8));
                }
                if ((double)r.nextFloat() < 0.5) {
                    byte[] data = Long.toString(r.nextLong(), 16).getBytes(StandardCharsets.UTF_8);
                    if (!dataSExists) {
                        zk.putPersistentData(rootDir + "/dataS", data, ZooUtil.NodeExistsPolicy.SKIP);
                        dataSExists = true;
                    } else {
                        zk.putPersistentData(rootDir + "/dataS", data, ZooUtil.NodeExistsPolicy.OVERWRITE);
                    }
                    expectedData.put(rootDir + "/dataS", new String(data, StandardCharsets.UTF_8));
                    continue;
                }
                if (!dataSExists) continue;
                zk.recursiveDelete(rootDir + "/dataS", ZooUtil.NodeMissingPolicy.FAIL);
                dataSExists = false;
            }
            System.out.println("expectedData " + expectedData);
            while (true) {
                File[] files;
                if ((files = reportDir.listFiles()) == null) {
                    throw new IllegalStateException("report directory is inaccessible");
                }
                System.out.println("files.length " + files.length);
                if (files.length == numReaders) {
                    boolean ok = true;
                    for (int i = 0; i < files.length; ++i) {
                        try {
                            FileInputStream fis = new FileInputStream(files[i]);
                            ObjectInputStream ois = new ObjectInputStream(fis);
                            Map readerMap = (Map)ois.readObject();
                            fis.close();
                            ois.close();
                            System.out.println("read " + readerMap);
                            if (readerMap.equals(expectedData)) continue;
                            System.out.println("maps not equals");
                            ok = false;
                            continue;
                        }
                        catch (IOException ioe) {
                            ok = false;
                        }
                    }
                    if (ok) continue block3;
                }
                UtilWaitThread.sleep((long)5L);
            }
        }
        zk.putPersistentData(rootDir + "/die", new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
    }
}

