/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.continuous;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.validators.PositiveInteger;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.apache.accumulo.core.cli.MapReduceClientOnDefaultTable;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.test.continuous.ContinuousIngest;
import org.apache.accumulo.test.continuous.ContinuousWalk;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.VLongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuousVerify
extends Configured
implements Tool {
    public static final VLongWritable DEF = new VLongWritable(-1L);

    public int run(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(((Object)((Object)this)).getClass().getName(), args, new Object[0]);
        Job job = Job.getInstance((Configuration)this.getConf(), (String)(((Object)((Object)this)).getClass().getSimpleName() + "_" + System.currentTimeMillis()));
        job.setJarByClass(((Object)((Object)this)).getClass());
        job.setInputFormatClass(AccumuloInputFormat.class);
        opts.setAccumuloConfigs(job);
        Set ranges = null;
        String clone = opts.getTableName();
        Connector conn = null;
        if (opts.scanOffline) {
            Random random = new Random();
            clone = opts.getTableName() + "_" + String.format("%016x", random.nextLong() & Long.MAX_VALUE);
            conn = opts.getConnector();
            conn.tableOperations().clone(opts.getTableName(), clone, true, new HashMap(), new HashSet());
            ranges = conn.tableOperations().splitRangeByTablets(opts.getTableName(), new Range(), opts.maxMaps);
            conn.tableOperations().offline(clone);
            AccumuloInputFormat.setInputTableName((Job)job, (String)clone);
            AccumuloInputFormat.setOfflineTableScan((Job)job, (boolean)true);
        } else {
            ranges = opts.getConnector().tableOperations().splitRangeByTablets(opts.getTableName(), new Range(), opts.maxMaps);
        }
        AccumuloInputFormat.setRanges((Job)job, (Collection)ranges);
        AccumuloInputFormat.setAutoAdjustRanges((Job)job, (boolean)false);
        job.setMapperClass(CMapper.class);
        job.setMapOutputKeyClass(LongWritable.class);
        job.setMapOutputValueClass(VLongWritable.class);
        job.setReducerClass(CReducer.class);
        job.setNumReduceTasks(opts.reducers);
        job.setOutputFormatClass(TextOutputFormat.class);
        job.getConfiguration().setBoolean("mapred.map.tasks.speculative.execution", opts.scanOffline);
        TextOutputFormat.setOutputPath((Job)job, (Path)new Path(opts.outputDir));
        job.waitForCompletion(true);
        if (opts.scanOffline) {
            conn.tableOperations().delete(clone);
        }
        opts.stopTracing();
        return job.isSuccessful() ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)CachedConfiguration.getInstance(), (Tool)new ContinuousVerify(), (String[])args);
        if (res != 0) {
            System.exit(res);
        }
    }

    static class Opts
    extends MapReduceClientOnDefaultTable {
        @Parameter(names={"--output"}, description="location in HDFS to store the results; must not exist", required=true)
        String outputDir = "/tmp/continuousVerify";
        @Parameter(names={"--maxMappers"}, description="the maximum number of mappers to use", required=true, validateWith=PositiveInteger.class)
        int maxMaps = 0;
        @Parameter(names={"--reducers"}, description="the number of reducers to use", required=true, validateWith=PositiveInteger.class)
        int reducers = 0;
        @Parameter(names={"--offline"}, description="perform the verification directly on the files while the table is offline")
        boolean scanOffline = false;

        public Opts() {
            super("ci");
        }
    }

    public static class CReducer
    extends Reducer<LongWritable, VLongWritable, Text, Text> {
        private ArrayList<Long> refs = new ArrayList();

        public void reduce(LongWritable key, Iterable<VLongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int defCount = 0;
            this.refs.clear();
            for (VLongWritable type : values) {
                if (type.get() == -1L) {
                    ++defCount;
                    continue;
                }
                this.refs.add(type.get());
            }
            if (defCount == 0 && this.refs.size() > 0) {
                StringBuilder sb = new StringBuilder();
                String comma = "";
                for (Long ref : this.refs) {
                    sb.append(comma);
                    comma = ",";
                    sb.append(new String(ContinuousIngest.genRow(ref), StandardCharsets.UTF_8));
                }
                context.write((Object)new Text(ContinuousIngest.genRow(key.get())), (Object)new Text(sb.toString()));
                context.getCounter((Enum)Counts.UNDEFINED).increment(1L);
            } else if (defCount > 0 && this.refs.size() == 0) {
                context.getCounter((Enum)Counts.UNREFERENCED).increment(1L);
            } else {
                context.getCounter((Enum)Counts.REFERENCED).increment(1L);
            }
        }
    }

    public static enum Counts {
        UNREFERENCED,
        UNDEFINED,
        REFERENCED,
        CORRUPT;

    }

    public static class CMapper
    extends Mapper<Key, Value, LongWritable, VLongWritable> {
        private static final Logger log = LoggerFactory.getLogger(CMapper.class);
        private LongWritable row = new LongWritable();
        private LongWritable ref = new LongWritable();
        private VLongWritable vrow = new VLongWritable();
        private long corrupt = 0L;

        public void map(Key key, Value data, Mapper.Context context) throws IOException, InterruptedException {
            long r = Long.parseLong(key.getRow().toString(), 16);
            if (r < 0L) {
                throw new IllegalArgumentException();
            }
            try {
                ContinuousWalk.validate(key, data);
            }
            catch (ContinuousWalk.BadChecksumException bce) {
                context.getCounter((Enum)Counts.CORRUPT).increment(1L);
                if (this.corrupt < 1000L) {
                    log.error("Bad checksum : " + key);
                } else if (this.corrupt == 1000L) {
                    System.out.println("Too many bad checksums, not printing anymore!");
                }
                ++this.corrupt;
                return;
            }
            this.row.set(r);
            context.write((Object)this.row, (Object)DEF);
            byte[] val = data.get();
            int offset = ContinuousWalk.getPrevRowOffset(val);
            if (offset > 0) {
                this.ref.set(Long.parseLong(new String(val, offset, 16, StandardCharsets.UTF_8), 16));
                this.vrow.set(r);
                context.write((Object)this.ref, (Object)this.vrow);
            }
        }
    }
}

