/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.continuous;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.iterators.ColumnFamilyCounter;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.Stat;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.cli.ClientOnRequiredTable;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.util.TableInfoUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuousStatsCollector {
    private static final Logger log = LoggerFactory.getLogger(ContinuousStatsCollector.class);

    private static String getMRStats() throws Exception {
        Configuration conf = CachedConfiguration.getInstance();
        JobClient jc = new JobClient(new JobConf(conf));
        ClusterStatus cs = jc.getClusterStatus(false);
        return "" + cs.getMapTasks() + " " + cs.getMaxMapTasks() + " " + cs.getReduceTasks() + " " + cs.getMaxReduceTasks() + " " + cs.getTaskTrackers() + " " + cs.getBlacklistedTrackers();
    }

    public static void main(String[] args) {
        Opts opts = new Opts();
        ScannerOpts scanOpts = new ScannerOpts();
        opts.parseArgs(ContinuousStatsCollector.class.getName(), args, new Object[]{scanOpts});
        Timer jtimer = new Timer();
        jtimer.schedule((TimerTask)new StatsCollectionTask(opts, scanOpts.scanBatchSize), 0L, 30000L);
    }

    static class Opts
    extends ClientOnRequiredTable {
        Opts() {
        }
    }

    static class StatsCollectionTask
    extends TimerTask {
        private final String tableId;
        private final Opts opts;
        private final int scanBatchSize;

        public StatsCollectionTask(Opts opts, int scanBatchSize) {
            this.opts = opts;
            this.scanBatchSize = scanBatchSize;
            this.tableId = (String)Tables.getNameToIdMap((Instance)opts.getInstance()).get(opts.getTableName());
            System.out.println("TIME TABLET_SERVERS TOTAL_ENTRIES TOTAL_INGEST TOTAL_QUERY TABLE_RECS TABLE_RECS_IN_MEM TABLE_INGEST TABLE_QUERY TABLE_TABLETS TABLE_TABLETS_ONLINE ACCUMULO_DU ACCUMULO_DIRS ACCUMULO_FILES TABLE_DU TABLE_DIRS TABLE_FILES MAP_TASK MAX_MAP_TASK REDUCE_TASK MAX_REDUCE_TASK TASK_TRACKERS BLACK_LISTED MIN_FILES/TABLET MAX_FILES/TABLET AVG_FILES/TABLET STDDEV_FILES/TABLET");
        }

        @Override
        public void run() {
            try {
                String acuStats = this.getACUStats();
                String fsStats = this.getFSStats();
                String mrStats = ContinuousStatsCollector.getMRStats();
                String tabletStats = this.getTabletStats();
                System.out.println(System.currentTimeMillis() + " " + acuStats + " " + fsStats + " " + mrStats + " " + tabletStats);
            }
            catch (Exception e) {
                log.error(System.currentTimeMillis() + " - Failed to collect stats", (Throwable)e);
            }
        }

        private String getTabletStats() throws Exception {
            Connector conn = this.opts.getConnector();
            Scanner scanner = conn.createScanner("accumulo.metadata", this.opts.auths);
            scanner.setBatchSize(this.scanBatchSize);
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            scanner.addScanIterator(new IteratorSetting(1000, "cfc", ColumnFamilyCounter.class.getName()));
            scanner.setRange(new KeyExtent(new Text(this.tableId), null, null).toMetadataRange());
            Stat s = new Stat();
            int count = 0;
            for (Map.Entry entry : scanner) {
                ++count;
                s.addStat(Long.parseLong(((Value)entry.getValue()).toString()));
            }
            if (count > 0) {
                return String.format("%d %d %.3f %.3f", s.getMin(), s.getMax(), s.getAverage(), s.getStdDev());
            }
            return "0 0 0 0";
        }

        private String getFSStats() throws Exception {
            VolumeManager fs = VolumeManagerImpl.get();
            long length1 = 0L;
            long dcount1 = 0L;
            long fcount1 = 0L;
            long length2 = 0L;
            long dcount2 = 0L;
            long fcount2 = 0L;
            for (String dir : ServerConstants.getTablesDirs()) {
                ContentSummary contentSummary = fs.getContentSummary(new Path(dir));
                length1 += contentSummary.getLength();
                dcount1 += contentSummary.getDirectoryCount();
                fcount1 += contentSummary.getFileCount();
                contentSummary = fs.getContentSummary(new Path(dir, this.tableId));
                length2 += contentSummary.getLength();
                dcount2 += contentSummary.getDirectoryCount();
                fcount2 += contentSummary.getFileCount();
            }
            return "" + length1 + " " + dcount1 + " " + fcount1 + " " + length2 + " " + dcount2 + " " + fcount2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getACUStats() throws Exception {
            String string;
            block6: {
                MasterClientService.Client client = null;
                try {
                    ClientContext context = new ClientContext(this.opts.getInstance(), new Credentials(this.opts.getPrincipal(), this.opts.getToken()), new ServerConfigurationFactory(this.opts.getInstance()).getConfiguration());
                    client = MasterClient.getConnectionWithRetry((ClientContext)context);
                    MasterMonitorInfo stats = client.getMasterStats(Tracer.traceInfo(), context.rpcCreds());
                    TableInfo all = new TableInfo();
                    HashMap tableSummaries = new HashMap();
                    for (TabletServerStatus server : stats.tServerInfo) {
                        for (Map.Entry info : server.tableMap.entrySet()) {
                            TableInfo tableSummary = (TableInfo)tableSummaries.get(info.getKey());
                            if (tableSummary == null) {
                                tableSummary = new TableInfo();
                                tableSummaries.put(info.getKey(), tableSummary);
                            }
                            TableInfoUtil.add((TableInfo)tableSummary, (TableInfo)((TableInfo)info.getValue()));
                            TableInfoUtil.add((TableInfo)all, (TableInfo)((TableInfo)info.getValue()));
                        }
                    }
                    TableInfo ti = (TableInfo)tableSummaries.get(this.tableId);
                    string = "" + stats.tServerInfo.size() + " " + all.recs + " " + (long)all.ingestRate + " " + (long)all.queryRate + " " + ti.recs + " " + ti.recsInMemory + " " + (long)ti.ingestRate + " " + (long)ti.queryRate + " " + ti.tablets + " " + ti.onlineTablets;
                    if (client == null) break block6;
                }
                catch (Throwable throwable) {
                    if (client != null) {
                        MasterClient.close(client);
                    }
                    throw throwable;
                }
                MasterClient.close((MasterClientService.Iface)client);
            }
            return string;
        }
    }
}

