/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.continuous;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.validators.PositiveInteger;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.apache.accumulo.core.cli.ClientOnDefaultTable;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.test.continuous.ContinuousIngest;
import org.apache.accumulo.test.continuous.ContinuousUtil;
import org.apache.accumulo.test.continuous.ContinuousWalk;
import org.apache.hadoop.io.Text;

public class ContinuousScanner {
    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        ScannerOpts scanOpts = new ScannerOpts();
        ClientOnDefaultTable clientOpts = new ClientOnDefaultTable("ci");
        clientOpts.parseArgs(ContinuousScanner.class.getName(), args, new Object[]{scanOpts, opts});
        Random r = new Random();
        long distance = 1000000000000L;
        Connector conn = clientOpts.getConnector();
        Authorizations auths = opts.randomAuths.getAuths(r);
        Scanner scanner = ContinuousUtil.createScanner(conn, clientOpts.getTableName(), auths);
        scanner.setBatchSize(scanOpts.scanBatchSize);
        double delta = Math.min(0.05, 0.05 / ((double)opts.numToScan / 1000.0));
        while (true) {
            long startRow = ContinuousIngest.genLong(opts.min, opts.max - distance, r);
            byte[] scanStart = ContinuousIngest.genRow(startRow);
            byte[] scanStop = ContinuousIngest.genRow(startRow + distance);
            scanner.setRange(new Range(new Text(scanStart), new Text(scanStop)));
            int count = 0;
            Iterator iter = scanner.iterator();
            long t1 = System.currentTimeMillis();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                ContinuousWalk.validate((Key)entry.getKey(), (Value)entry.getValue());
                ++count;
            }
            long t2 = System.currentTimeMillis();
            if ((double)count < (1.0 - delta) * (double)opts.numToScan || (double)count > (1.0 + delta) * (double)opts.numToScan) {
                if (count == 0) {
                    if ((distance *= 10L) < 0L) {
                        distance = 1000000000000L;
                    }
                } else {
                    double ratio = (double)opts.numToScan / (double)count;
                    ratio -= (ratio - 1.0) * 0.6666666666666666;
                    distance = (long)(ratio * (double)distance);
                }
            }
            System.out.printf("SCN %d %s %d %d%n", t1, new String(scanStart, StandardCharsets.UTF_8), t2 - t1, count);
            if (opts.sleepTime <= 0L) continue;
            UtilWaitThread.sleep((long)opts.sleepTime);
        }
    }

    static class Opts
    extends ContinuousWalk.Opts {
        @Parameter(names={"--numToScan"}, description="Number rows to scan between sleeps", required=true, validateWith=PositiveInteger.class)
        long numToScan = 0L;

        Opts() {
        }
    }
}

