/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ClientOnDefaultTable;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.TabletServerBatchWriter;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.ConstraintViolationSummary;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.trace.DistributedTrace;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class TestIngest {
    public static final Authorizations AUTHS = new Authorizations(new String[]{"L1", "L2", "G1", "GROUP2"});
    private static byte[] ROW_PREFIX = "row_".getBytes(StandardCharsets.UTF_8);
    private static byte[] COL_PREFIX = "col_".getBytes(StandardCharsets.UTF_8);

    public static void createTable(Connector conn, Opts args) throws AccumuloException, AccumuloSecurityException, TableExistsException {
        if (args.createTable) {
            TreeSet<Text> splits = TestIngest.getSplitPoints(args.startRow, args.startRow + args.rows, args.numsplits);
            if (!conn.tableOperations().exists(args.getTableName())) {
                conn.tableOperations().create(args.getTableName());
            }
            try {
                conn.tableOperations().addSplits(args.getTableName(), splits);
            }
            catch (TableNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static TreeSet<Text> getSplitPoints(long start, long end, long numsplits) {
        long splitSize = (end - start) / numsplits;
        TreeSet<Text> splits = new TreeSet<Text>();
        for (long pos = start + splitSize; pos < end; pos += splitSize) {
            splits.add(new Text(String.format("row_%010d", pos)));
        }
        return splits;
    }

    public static byte[][] generateValues(int dataSize) {
        byte[][] bytevals = new byte[10][];
        byte[] letters = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 48};
        for (int i = 0; i < 10; ++i) {
            bytevals[i] = new byte[dataSize];
            for (int j = 0; j < dataSize; ++j) {
                bytevals[i][j] = letters[i];
            }
        }
        return bytevals;
    }

    public static Text generateRow(int rowid, int startRow) {
        return new Text(FastFormat.toZeroPaddedString((long)(rowid + startRow), (int)10, (int)10, (byte[])ROW_PREFIX));
    }

    public static byte[] genRandomValue(Random random, byte[] dest, int seed, int row, int col) {
        random.setSeed(row ^ seed ^ col);
        random.nextBytes(dest);
        TestIngest.toPrintableChars(dest);
        return dest;
    }

    public static void toPrintableChars(byte[] dest) {
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = (byte)((0xFF & dest[i]) % 92 + 32);
        }
    }

    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        BatchWriterOpts bwOpts = new BatchWriterOpts();
        opts.parseArgs(TestIngest.class.getName(), args, new Object[]{bwOpts});
        String name = TestIngest.class.getSimpleName();
        DistributedTrace.enable((String)name);
        try {
            opts.startTracing(name);
            if (opts.debug) {
                Logger.getLogger((String)TabletServerBatchWriter.class.getName()).setLevel(Level.TRACE);
            }
            TestIngest.ingest(opts.getConnector(), opts, bwOpts);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            opts.stopTracing();
            DistributedTrace.disable();
        }
    }

    public static void ingest(Connector connector, Opts opts, BatchWriterOpts bwOpts) throws IOException, AccumuloException, AccumuloSecurityException, TableNotFoundException, MutationsRejectedException, TableExistsException {
        byte[][] bytevals = TestIngest.generateValues(opts.dataSize);
        byte[] randomValue = new byte[opts.dataSize];
        Random random = new Random();
        long bytesWritten = 0L;
        TestIngest.createTable(connector, opts);
        BatchWriter bw = null;
        FileSKVWriter writer = null;
        if (opts.outputFile != null) {
            Configuration conf = CachedConfiguration.getInstance();
            FileSystem fs = FileSystem.get((Configuration)conf);
            writer = FileOperations.getInstance().openWriter(opts.outputFile + "." + "rf", fs, conf, (AccumuloConfiguration)AccumuloConfiguration.getDefaultConfiguration());
            writer.startDefaultLocalityGroup();
        } else {
            bw = connector.createBatchWriter(opts.getTableName(), bwOpts.getBatchWriterConfig());
            connector.securityOperations().changeUserAuthorizations(opts.getPrincipal(), AUTHS);
        }
        Text labBA = new Text(opts.columnVisibility.getExpression());
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < opts.rows; ++i) {
            int rowid = opts.stride > 0 ? i % opts.stride * (opts.rows / opts.stride) + i / opts.stride : i;
            Text row = TestIngest.generateRow(rowid, opts.startRow);
            Mutation m = new Mutation(row);
            for (int j = 0; j < opts.cols; ++j) {
                byte[] value;
                Key key;
                Text colf = new Text(opts.columnFamily);
                Text colq = new Text(FastFormat.toZeroPaddedString((long)j, (int)7, (int)10, (byte[])COL_PREFIX));
                if (writer != null) {
                    key = new Key(row, colf, colq, labBA);
                    if (opts.timestamp >= 0L) {
                        key.setTimestamp(opts.timestamp);
                    } else {
                        key.setTimestamp(startTime);
                    }
                    if (opts.delete) {
                        key.setDeleted(true);
                    } else {
                        key.setDeleted(false);
                    }
                    bytesWritten += (long)key.getSize();
                    if (opts.delete) {
                        writer.append(key, new Value(new byte[0]));
                        continue;
                    }
                    value = opts.random != null ? TestIngest.genRandomValue(random, randomValue, opts.random, rowid + opts.startRow, j) : bytevals[j % bytevals.length];
                    Value v = new Value(value);
                    writer.append(key, v);
                    bytesWritten += (long)v.getSize();
                    continue;
                }
                key = new Key(row, colf, colq, labBA);
                bytesWritten += (long)key.getSize();
                if (opts.delete) {
                    if (opts.timestamp >= 0L) {
                        m.putDelete(colf, colq, opts.columnVisibility, opts.timestamp);
                        continue;
                    }
                    m.putDelete(colf, colq, opts.columnVisibility);
                    continue;
                }
                value = opts.random != null ? TestIngest.genRandomValue(random, randomValue, opts.random, rowid + opts.startRow, j) : bytevals[j % bytevals.length];
                bytesWritten += (long)value.length;
                if (opts.timestamp >= 0L) {
                    m.put(colf, colq, opts.columnVisibility, opts.timestamp, new Value(value, true));
                    continue;
                }
                m.put(colf, colq, opts.columnVisibility, new Value(value, true));
            }
            if (bw == null) continue;
            bw.addMutation(m);
        }
        if (writer != null) {
            writer.close();
        } else if (bw != null) {
            try {
                bw.close();
            }
            catch (MutationsRejectedException e) {
                if (e.getSecurityErrorCodes().size() > 0) {
                    for (Map.Entry entry : e.getSecurityErrorCodes().entrySet()) {
                        System.err.println("ERROR : Not authorized to write to : " + entry.getKey() + " due to " + entry.getValue());
                    }
                }
                if (e.getConstraintViolationSummaries().size() > 0) {
                    for (ConstraintViolationSummary cvs : e.getConstraintViolationSummaries()) {
                        System.err.println("ERROR : Constraint violates : " + cvs);
                    }
                }
                throw e;
            }
        }
        long stopTime = System.currentTimeMillis();
        int totalValues = opts.rows * opts.cols;
        double elapsed = (double)(stopTime - startTime) / 1000.0;
        System.out.printf("%,12d records written | %,8d records/sec | %,12d bytes written | %,8d bytes/sec | %6.3f secs   %n", totalValues, (int)((double)totalValues / elapsed), bytesWritten, (int)((double)bytesWritten / elapsed), elapsed);
    }

    public static class Opts
    extends ClientOnDefaultTable {
        @Parameter(names={"--createTable"})
        public boolean createTable = false;
        @Parameter(names={"--splits"}, description="the number of splits to use when creating the table")
        public int numsplits = 1;
        @Parameter(names={"--start"}, description="the starting row number")
        public int startRow = 0;
        @Parameter(names={"--rows"}, description="the number of rows to ingest")
        public int rows = 100000;
        @Parameter(names={"--cols"}, description="the number of columns to ingest per row")
        public int cols = 1;
        @Parameter(names={"--random"}, description="insert random rows and use the given number to seed the psuedo-random number generator")
        public Integer random = null;
        @Parameter(names={"--size"}, description="the size of the value to ingest")
        public int dataSize = 1000;
        @Parameter(names={"--delete"}, description="delete values instead of inserting them")
        public boolean delete = false;
        @Parameter(names={"-ts", "--timestamp"}, description="timestamp to use for all values")
        public long timestamp = -1L;
        @Parameter(names={"--rfile"}, description="generate data into a file that can be imported")
        public String outputFile = null;
        @Parameter(names={"--stride"}, description="the difference between successive row ids")
        public int stride;
        @Parameter(names={"-cf", "--columnFamily"}, description="place columns in this column family")
        public String columnFamily = "colf";
        @Parameter(names={"-cv", "--columnVisibility"}, description="place columns in this column family", converter=ClientOpts.VisibilityConverter.class)
        public ColumnVisibility columnVisibility = new ColumnVisibility();
        public Configuration conf = null;
        public FileSystem fs = null;

        public Opts() {
            super("test_ingest");
        }
    }
}

