/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.beust.jcommander.Parameter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class QueryMetadataTable {
    private static final Logger log = Logger.getLogger(QueryMetadataTable.class);
    private static String principal;
    private static AuthenticationToken token;
    static String location;

    public static void main(String[] args) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Opts opts = new Opts();
        ScannerOpts scanOpts = new ScannerOpts();
        opts.parseArgs(QueryMetadataTable.class.getName(), args, new Object[]{scanOpts});
        Connector connector = opts.getConnector();
        Scanner scanner = connector.createScanner("accumulo.metadata", opts.auths);
        scanner.setBatchSize(scanOpts.scanBatchSize);
        Text mdrow = new Text(KeyExtent.getMetadataEntry((Text)new Text("!0"), null));
        HashSet<Text> rowSet = new HashSet<Text>();
        int count = 0;
        for (Map.Entry entry : scanner) {
            System.out.print(".");
            if (count % 72 == 0) {
                System.out.printf(" %,d%n", count);
            }
            if (((Key)entry.getKey()).compareRow(mdrow) == 0 && ((Key)entry.getKey()).getColumnFamily().compareTo((BinaryComparable)MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME) == 0) {
                System.out.println(entry.getKey() + " " + entry.getValue());
                location = ((Value)entry.getValue()).toString();
            }
            if (!((Key)entry.getKey()).getRow().toString().startsWith("!0")) {
                rowSet.add(((Key)entry.getKey()).getRow());
            }
            ++count;
        }
        System.out.printf(" %,d%n", count);
        ArrayList rows = new ArrayList(rowSet);
        Random r = new Random();
        ExecutorService tp = Executors.newFixedThreadPool(opts.numThreads);
        long t1 = System.currentTimeMillis();
        for (int i = 0; i < opts.numQueries; ++i) {
            int index = r.nextInt(rows.size());
            MDTQuery mdtq = new MDTQuery((Text)rows.get(index));
            tp.submit(mdtq);
        }
        tp.shutdown();
        try {
            tp.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            log.error((Object)"Failed while awaiting the ExcecutorService to terminate.", (Throwable)e);
            throw new RuntimeException(e);
        }
        long t2 = System.currentTimeMillis();
        double delta = (double)(t2 - t1) / 1000.0;
        System.out.println("time : " + delta + "  queries per sec : " + (double)opts.numQueries / delta);
    }

    static class Opts
    extends ClientOpts {
        @Parameter(names={"--numQueries"}, description="number of queries to run")
        int numQueries = 1;
        @Parameter(names={"--numThreads"}, description="number of threads used to run the queries")
        int numThreads = 1;

        Opts() {
        }
    }

    static class MDTQuery
    implements Runnable {
        private Text row;

        MDTQuery(Text row) {
            this.row = row;
        }

        @Override
        public void run() {
            try {
                Map.Entry entry;
                KeyExtent extent = new KeyExtent(this.row, (Text)null);
                Connector connector = HdfsZooInstance.getInstance().getConnector(principal, token);
                Scanner mdScanner = connector.createScanner("accumulo.metadata", Authorizations.EMPTY);
                Text row = extent.getMetadataEntry();
                mdScanner.setRange(new Range(row));
                Iterator iterator = mdScanner.iterator();
                while (iterator.hasNext() && ((Key)(entry = (Map.Entry)iterator.next()).getKey()).getRow().equals((Object)row)) {
                }
            }
            catch (TableNotFoundException e) {
                log.error((Object)"Table 'accumulo.metadata' not found.", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (AccumuloException e) {
                log.error((Object)"AccumuloException encountered.", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (AccumuloSecurityException e) {
                log.error((Object)"AccumuloSecurityException encountered.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

