/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.Collections;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.test.MemoryUsageTest;
import org.apache.accumulo.tserver.InMemoryMap;
import org.apache.hadoop.io.Text;

class InMemoryMapMemoryUsageTest
extends MemoryUsageTest {
    private int keyLen;
    private int colFamLen;
    private int colQualLen;
    private int colVisLen;
    private int dataLen;
    private InMemoryMap imm;
    private Text key;
    private Text colf;
    private Text colq;
    private ColumnVisibility colv;
    private int passes;

    InMemoryMapMemoryUsageTest(int passes, int keyLen, int colFamLen, int colQualLen, int colVisLen, int dataLen) {
        this.keyLen = keyLen;
        this.colFamLen = colFamLen;
        this.colQualLen = colQualLen;
        this.dataLen = dataLen;
        this.passes = passes;
        this.colVisLen = colVisLen;
    }

    @Override
    void init() {
        this.imm = new InMemoryMap(false, "/tmp");
        this.key = new Text();
        this.colf = new Text(String.format("%0" + this.colFamLen + "d", 0));
        this.colq = new Text(String.format("%0" + this.colQualLen + "d", 0));
        this.colv = new ColumnVisibility(String.format("%0" + this.colVisLen + "d", 0));
    }

    @Override
    public void addEntry(int i) {
        this.key.set(String.format("%0" + this.keyLen + "d", i));
        Mutation m = new Mutation(this.key);
        byte[] data = new byte[this.dataLen];
        for (int j = 0; j < data.length; ++j) {
            data[j] = (byte)(j % 10 + 65);
        }
        Value idata = new Value(data);
        m.put(this.colf, this.colq, this.colv, idata);
        this.imm.mutate(Collections.singletonList(m));
    }

    @Override
    public int getEstimatedBytesPerEntry() {
        return this.keyLen + this.colFamLen + this.colQualLen + this.dataLen + 4 + this.colVisLen;
    }

    @Override
    public void clear() {
        this.imm = null;
        this.key = null;
        this.colf = null;
        this.colq = null;
    }

    @Override
    int getNumPasses() {
        return this.passes;
    }

    @Override
    String getName() {
        return "IMM " + this.keyLen + " " + this.colFamLen + " " + this.colQualLen + " " + this.dataLen;
    }
}

