/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CleanUpBulkImport
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(CleanUpBulkImport.class);
    private String tableId;
    private String source;
    private String bulk;
    private String error;

    public CleanUpBulkImport(String tableId, String source, String bulk, String error) {
        this.tableId = tableId;
        this.source = source;
        this.bulk = bulk;
        this.error = error;
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        log.debug("removing the bulk processing flag file in " + this.bulk);
        Path bulkDir = new Path(this.bulk);
        MetadataTableUtil.removeBulkLoadInProgressFlag((AccumuloServerContext)master, (String)("/" + bulkDir.getParent().getName() + "/" + bulkDir.getName()));
        MetadataTableUtil.addDeleteEntry((AccumuloServerContext)master, (String)this.tableId, (String)bulkDir.toString());
        log.debug("removing the metadata table markers for loaded files");
        Connector conn = master.getConnector();
        MetadataTableUtil.removeBulkLoadEntries((Connector)conn, (String)this.tableId, (long)tid);
        log.debug("releasing HDFS reservations for " + this.source + " and " + this.error);
        Utils.unreserveHdfsDirectory(this.source, tid);
        Utils.unreserveHdfsDirectory(this.error, tid);
        Utils.getReadLock(this.tableId, tid).unlock();
        log.debug("completing bulk import transaction " + tid);
        TransactionWatcher.ZooArbitrator.cleanup((String)"bulkTx", (long)tid);
        return null;
    }
}

