/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.metrics;

import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.metrics.Metrics;
import org.apache.accumulo.server.replication.ReplicationUtil;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;

public class Metrics2ReplicationMetrics
implements Metrics,
MetricsSource {
    public static final String NAME = "Master,sub=Replication";
    public static final String DESCRIPTION = "Data-Center Replication Metrics";
    public static final String CONTEXT = "master";
    public static final String RECORD = "MasterReplication";
    public static final String PENDING_FILES = "filesPendingReplication";
    public static final String NUM_PEERS = "numPeers";
    public static final String MAX_REPLICATION_THREADS = "maxReplicationThreads";
    private final Master master;
    private final MetricsSystem system;
    private final MetricsRegistry registry;
    private final ReplicationUtil replicationUtil;

    Metrics2ReplicationMetrics(Master master, MetricsSystem system) {
        this.master = master;
        this.system = system;
        this.registry = new MetricsRegistry(Interns.info((String)NAME, (String)DESCRIPTION));
        this.replicationUtil = new ReplicationUtil((AccumuloServerContext)master);
    }

    protected void snapshot() {
        this.registry.add(PENDING_FILES, (long)this.getNumFilesPendingReplication());
        this.registry.add(NUM_PEERS, (long)this.getNumConfiguredPeers());
        this.registry.add(MAX_REPLICATION_THREADS, (long)this.getMaxReplicationThreads());
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder builder = collector.addRecord(RECORD).setContext(CONTEXT);
        this.snapshot();
        this.registry.snapshot(builder, all);
    }

    public void register() throws Exception {
        this.system.register(NAME, DESCRIPTION, (Object)this);
    }

    public void add(String name, long time) {
        throw new UnsupportedOperationException("add() is not implemented");
    }

    public boolean isEnabled() {
        return true;
    }

    protected int getNumFilesPendingReplication() {
        if (TableState.ONLINE != Tables.getTableState((Instance)this.master.getInstance(), (String)"+rep")) {
            return 0;
        }
        Map peers = this.replicationUtil.getPeers();
        if (peers.isEmpty()) {
            return 0;
        }
        Set allConfiguredTargets = this.replicationUtil.getReplicationTargets();
        Map targetCounts = this.replicationUtil.getPendingReplications();
        int filesPending = 0;
        for (ReplicationTarget configuredTarget : allConfiguredTargets) {
            Long numFiles = (Long)targetCounts.get(configuredTarget);
            if (null == numFiles) continue;
            filesPending = (int)((long)filesPending + numFiles);
        }
        return filesPending;
    }

    protected int getNumConfiguredPeers() {
        return this.replicationUtil.getPeers().size();
    }

    protected int getMaxReplicationThreads() {
        return this.replicationUtil.getMaxReplicationThreads(this.master.getMasterMonitorInfo());
    }
}

