/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.Configuration;
import alluxio.client.ClientContext;
import alluxio.client.file.FileSystem;
import alluxio.master.AlluxioMaster;
import alluxio.master.ClientPool;
import alluxio.master.MasterContext;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.network.NetworkAddressUtils;
import com.google.common.base.Supplier;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class LocalAlluxioMaster {
    private final String mHostname;
    private final String mJournalFolder;
    private final AlluxioMaster mAlluxioMaster;
    private final Thread mMasterThread;
    private final Supplier<String> mClientSupplier = new Supplier<String>(){

        public String get() {
            return LocalAlluxioMaster.this.getUri();
        }
    };
    private final ClientPool mClientPool = new ClientPool(this.mClientSupplier);

    private LocalAlluxioMaster() throws IOException {
        Configuration configuration = MasterContext.getConf();
        this.mHostname = NetworkAddressUtils.getConnectHost((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.MASTER_RPC, (Configuration)configuration);
        this.mJournalFolder = configuration.get("alluxio.master.journal.folder");
        this.mAlluxioMaster = AlluxioMaster.Factory.create();
        configuration.set("alluxio.master.port", Integer.toString(this.getRPCLocalPort()));
        Runnable runMaster = new Runnable(){

            @Override
            public void run() {
                try {
                    LocalAlluxioMaster.this.mAlluxioMaster.start();
                }
                catch (Exception e) {
                    throw new RuntimeException(e + " \n Start Master Error \n" + e.getMessage(), e);
                }
            }
        };
        this.mMasterThread = new Thread(runMaster);
    }

    public static LocalAlluxioMaster create() throws IOException {
        String alluxioHome = LocalAlluxioMaster.uniquePath();
        Configuration configuration = MasterContext.getConf();
        UnderFileSystemUtils.deleteDir((String)alluxioHome, (Configuration)configuration);
        UnderFileSystemUtils.mkdirIfNotExists((String)alluxioHome, (Configuration)configuration);
        configuration.set("alluxio.home", alluxioHome);
        return new LocalAlluxioMaster();
    }

    public static LocalAlluxioMaster create(String alluxioHome) throws IOException {
        Configuration configuration = MasterContext.getConf();
        UnderFileSystemUtils.mkdirIfNotExists((String)alluxioHome, (Configuration)configuration);
        return new LocalAlluxioMaster();
    }

    public void start() {
        this.mMasterThread.start();
    }

    public boolean isServing() {
        return this.mAlluxioMaster.isServing();
    }

    public void stop() throws Exception {
        this.clearClients();
        this.mAlluxioMaster.stop();
        System.clearProperty("alluxio.web.resources");
        System.clearProperty("alluxio.master.min.worker.threads");
    }

    public void kill() throws Exception {
        this.mMasterThread.interrupt();
    }

    public void clearClients() throws IOException {
        this.mClientPool.close();
    }

    public InetSocketAddress getAddress() {
        return this.mAlluxioMaster.getMasterAddress();
    }

    public AlluxioMaster getInternalMaster() {
        return this.mAlluxioMaster;
    }

    public String getRPCBindHost() {
        return this.mAlluxioMaster.getRPCBindHost();
    }

    public int getRPCLocalPort() {
        return this.mAlluxioMaster.getRPCLocalPort();
    }

    public String getWebBindHost() {
        return this.mAlluxioMaster.getWebBindHost();
    }

    public int getWebLocalPort() {
        return this.mAlluxioMaster.getWebLocalPort();
    }

    public String getUri() {
        return "alluxio://" + this.mHostname + ":" + this.getRPCLocalPort();
    }

    public FileSystem getClient() throws IOException {
        return this.mClientPool.getClient(ClientContext.getConf());
    }

    private static String uniquePath() throws IOException {
        return File.createTempFile("Alluxio", "").getAbsoluteFile() + "U" + System.nanoTime();
    }

    public String getJournalFolder() {
        return this.mJournalFolder;
    }
}

