/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.mainlayout;

import com.vaadin.terminal.Resource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.MenuBar;
import java.util.HashMap;
import java.util.Map;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ViewManager;
import org.activiti.explorer.identity.LoggedInUser;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.profile.ChangePasswordPopupWindow;

public class MainMenuBar
extends HorizontalLayout {
    private static final long serialVersionUID = 1L;
    protected ViewManager viewManager = ExplorerApp.get().getViewManager();
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected Map<String, Button> menuItemButtons = new HashMap<String, Button>();
    protected String currentMainNavigation;

    public MainMenuBar() {
        this.init();
    }

    public synchronized void setMainNavigation(String navigation) {
        if (this.currentMainNavigation != null) {
            this.menuItemButtons.get(this.currentMainNavigation).removeStyleName("active");
        }
        this.currentMainNavigation = navigation;
        Button current = this.menuItemButtons.get(navigation);
        if (current != null) {
            current.addStyleName("active");
        }
    }

    protected void init() {
        this.setHeight(54.0f, 0);
        this.setWidth(100.0f, 8);
        this.setMargin(false, true, false, false);
        this.initTitle();
        this.initButtons();
        this.initProfileButton();
    }

    protected void initButtons() {
        Button taskButton = this.addMenuButton("task", this.i18nManager.getMessage("main.menu.tasks"), Images.MAIN_MENU_TASKS, false, 80.0f);
        taskButton.addListener((Button.ClickListener)new ShowTasksClickListener());
        this.menuItemButtons.put("task", taskButton);
        Button processButton = this.addMenuButton("process", this.i18nManager.getMessage("main.menu.process"), Images.MAIN_MENU_PROCESS, false, 80.0f);
        processButton.addListener((Button.ClickListener)new ShowProcessDefinitionsClickListener());
        this.menuItemButtons.put("process", processButton);
        Button reportingButton = this.addMenuButton("report", this.i18nManager.getMessage("main.menu.reports"), Images.MAIN_MENU_REPORTS, false, 80.0f);
        reportingButton.addListener((Button.ClickListener)new ShowReportsClickListener());
        this.menuItemButtons.put("report", reportingButton);
        if (ExplorerApp.get().getLoggedInUser().isAdmin()) {
            Button manageButton = this.addMenuButton("manage", this.i18nManager.getMessage("main.menu.management"), Images.MAIN_MENU_MANAGE, false, 90.0f);
            manageButton.addListener((Button.ClickListener)new ShowManagementClickListener());
            this.menuItemButtons.put("manage", manageButton);
        }
    }

    protected void initTitle() {
        Label title = new Label();
        title.addStyleName("h1");
        if (ExplorerApp.get().getEnvironment().equals("alfresco")) {
            title.addStyleName("workflow-console-logo");
        } else {
            title.addStyleName("logo");
        }
        this.addComponent((Component)title);
        this.setExpandRatio((Component)title, 1.0f);
    }

    protected Button addMenuButton(String type, String label, Resource icon, boolean active, float width) {
        Button button = new Button(label);
        button.addStyleName(type);
        button.addStyleName("main-menu-button");
        button.addStyleName("link");
        button.setHeight(54.0f, 0);
        button.setIcon(icon);
        button.setWidth(width, 0);
        this.addComponent((Component)button);
        this.setComponentAlignment((Component)button, Alignment.TOP_CENTER);
        return button;
    }

    protected void initProfileButton() {
        final LoggedInUser user = ExplorerApp.get().getLoggedInUser();
        MenuBar profileMenu = new MenuBar();
        profileMenu.addStyleName("person");
        MenuBar.MenuItem rootItem = profileMenu.addItem(user.getFirstName() + " " + user.getLastName(), null);
        rootItem.setStyleName("person-menu");
        if (this.useProfile()) {
            rootItem.addItem(this.i18nManager.getMessage("profile.show"), new MenuBar.Command(){

                public void menuSelected(MenuBar.MenuItem selectedItem) {
                    ExplorerApp.get().getViewManager().showProfilePopup(user.getId());
                }
            });
            rootItem.addItem(this.i18nManager.getMessage("profile.edit"), new MenuBar.Command(){

                public void menuSelected(MenuBar.MenuItem selectedItem) {
                    ExplorerApp.get().getViewManager().showProfilePopup(user.getId());
                }
            });
            rootItem.addItem(this.i18nManager.getMessage("password.change"), new MenuBar.Command(){

                public void menuSelected(MenuBar.MenuItem selectedItem) {
                    ExplorerApp.get().getViewManager().showPopupWindow(new ChangePasswordPopupWindow());
                }
            });
            rootItem.addSeparator();
        }
        rootItem.addItem(this.i18nManager.getMessage("header.logout"), new MenuBar.Command(){

            public void menuSelected(MenuBar.MenuItem selectedItem) {
                ExplorerApp.get().close();
            }
        });
        this.addComponent((Component)profileMenu);
        this.setComponentAlignment((Component)profileMenu, Alignment.TOP_RIGHT);
        this.setExpandRatio((Component)profileMenu, 1.0f);
    }

    protected boolean useProfile() {
        return true;
    }

    private class ShowManagementClickListener
    implements Button.ClickListener {
        private ShowManagementClickListener() {
        }

        public void buttonClick(Button.ClickEvent event) {
            ExplorerApp.get().getViewManager().showDatabasePage();
        }
    }

    private class ShowReportsClickListener
    implements Button.ClickListener {
        private ShowReportsClickListener() {
        }

        public void buttonClick(Button.ClickEvent event) {
            ExplorerApp.get().getViewManager().showRunReportPage();
        }
    }

    private class ShowProcessDefinitionsClickListener
    implements Button.ClickListener {
        private ShowProcessDefinitionsClickListener() {
        }

        public void buttonClick(Button.ClickEvent event) {
            ExplorerApp.get().getViewManager().showDeployedProcessDefinitionPage();
        }
    }

    private class ShowTasksClickListener
    implements Button.ClickListener {
        private ShowTasksClickListener() {
        }

        public void buttonClick(Button.ClickEvent event) {
            ExplorerApp.get().getViewManager().showInboxPage();
        }
    }
}

