/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost.signature;

import oauth.signpost.OAuth;
import oauth.signpost.http.HttpRequest;
import oauth.signpost.http.RequestParameters;
import oauth.signpost.signature.SigningStrategy;

public class QueryStringSigningStrategy
implements SigningStrategy {
    private static final long serialVersionUID = 1L;

    public String writeSignature(String signature, HttpRequest request, RequestParameters requestParameters) {
        StringBuilder sb = new StringBuilder(OAuth.addQueryParameters(request.getRequestUrl(), "oauth_signature", signature));
        if (requestParameters.containsKey("oauth_token")) {
            sb.append("&");
            sb.append(requestParameters.getFormEncoded("oauth_token"));
        }
        if (requestParameters.containsKey("oauth_callback")) {
            sb.append("&");
            sb.append(requestParameters.getFormEncoded("oauth_callback"));
        }
        sb.append("&");
        sb.append(requestParameters.getFormEncoded("oauth_consumer_key"));
        sb.append("&");
        sb.append(requestParameters.getFormEncoded("oauth_version"));
        sb.append("&");
        sb.append(requestParameters.getFormEncoded("oauth_signature_method"));
        sb.append("&");
        sb.append(requestParameters.getFormEncoded("oauth_timestamp"));
        sb.append("&");
        sb.append(requestParameters.getFormEncoded("oauth_nonce"));
        String signedUrl = sb.toString();
        request.setRequestUrl(signedUrl);
        return signedUrl;
    }
}

