/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import edu.uci.ics.jung.visualization.util.ArrowFactory;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import org.apache.commons.collections15.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditingGraphMousePlugin<V, E>
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    protected V startVertex;
    protected Point2D down;
    protected CubicCurve2D rawEdge = new CubicCurve2D.Float();
    protected Shape edgeShape;
    protected Shape rawArrowShape;
    protected Shape arrowShape;
    protected VisualizationServer.Paintable edgePaintable;
    protected VisualizationServer.Paintable arrowPaintable;
    protected EdgeType edgeIsDirected;
    protected Factory<V> vertexFactory;
    protected Factory<E> edgeFactory;

    public EditingGraphMousePlugin(Factory<V> vertexFactory, Factory<E> edgeFactory) {
        this(16, vertexFactory, edgeFactory);
    }

    public EditingGraphMousePlugin(int modifiers, Factory<V> vertexFactory, Factory<E> edgeFactory) {
        super(modifiers);
        this.vertexFactory = vertexFactory;
        this.edgeFactory = edgeFactory;
        this.rawEdge.setCurve(0.0, 0.0, 0.33f, 100.0, 0.66f, -50.0, 1.0, 0.0);
        this.rawArrowShape = ArrowFactory.getNotchedArrow(20.0f, 16.0f, 8.0f);
        this.edgePaintable = new EdgePaintable();
        this.arrowPaintable = new ArrowPaintable();
        this.cursor = Cursor.getPredefinedCursor(1);
    }

    @Override
    public boolean checkModifiers(MouseEvent e) {
        return (e.getModifiers() & this.modifiers) != 0;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.checkModifiers(e)) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            Point p = e.getPoint();
            GraphElementAccessor pickSupport = vv.getPickSupport();
            if (pickSupport != null) {
                Graph graph = vv.getModel().getGraphLayout().getGraph();
                this.edgeIsDirected = graph instanceof DirectedGraph ? EdgeType.DIRECTED : EdgeType.UNDIRECTED;
                Object vertex = pickSupport.getVertex(vv.getModel().getGraphLayout(), ((Point2D)p).getX(), ((Point2D)p).getY());
                if (vertex != null) {
                    this.startVertex = vertex;
                    this.down = e.getPoint();
                    this.transformEdgeShape(this.down, this.down);
                    vv.addPostRenderPaintable(this.edgePaintable);
                    if ((e.getModifiers() & 1) != 0 && !(vv.getModel().getGraphLayout().getGraph() instanceof UndirectedGraph)) {
                        this.edgeIsDirected = EdgeType.DIRECTED;
                    }
                    if (this.edgeIsDirected == EdgeType.DIRECTED) {
                        this.transformArrowShape(this.down, e.getPoint());
                        vv.addPostRenderPaintable(this.arrowPaintable);
                    }
                } else {
                    Object newVertex = this.vertexFactory.create();
                    Layout layout = vv.getModel().getGraphLayout();
                    graph.addVertex(newVertex);
                    layout.setLocation(newVertex, vv.getRenderContext().getMultiLayerTransformer().inverseTransform(e.getPoint()));
                }
            }
            vv.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.checkModifiers(e)) {
            Object vertex;
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            Point p = e.getPoint();
            Layout layout = vv.getModel().getGraphLayout();
            GraphElementAccessor pickSupport = vv.getPickSupport();
            if (pickSupport != null && (vertex = pickSupport.getVertex(layout, ((Point2D)p).getX(), ((Point2D)p).getY())) != null && this.startVertex != null) {
                Graph graph = vv.getGraphLayout().getGraph();
                graph.addEdge(this.edgeFactory.create(), this.startVertex, vertex, this.edgeIsDirected);
                vv.repaint();
            }
            this.startVertex = null;
            this.down = null;
            this.edgeIsDirected = EdgeType.UNDIRECTED;
            vv.removePostRenderPaintable(this.edgePaintable);
            vv.removePostRenderPaintable(this.arrowPaintable);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.checkModifiers(e)) {
            if (this.startVertex != null) {
                this.transformEdgeShape(this.down, e.getPoint());
                if (this.edgeIsDirected == EdgeType.DIRECTED) {
                    this.transformArrowShape(this.down, e.getPoint());
                }
            }
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            vv.repaint();
        }
    }

    private void transformEdgeShape(Point2D down, Point2D out) {
        float x1 = (float)down.getX();
        float y1 = (float)down.getY();
        float x2 = (float)out.getX();
        float y2 = (float)out.getY();
        AffineTransform xform = AffineTransform.getTranslateInstance(x1, y1);
        float dx = x2 - x1;
        float dy = y2 - y1;
        float thetaRadians = (float)Math.atan2(dy, dx);
        xform.rotate(thetaRadians);
        float dist = (float)Math.sqrt(dx * dx + dy * dy);
        xform.scale((double)dist / this.rawEdge.getBounds().getWidth(), 1.0);
        this.edgeShape = xform.createTransformedShape(this.rawEdge);
    }

    private void transformArrowShape(Point2D down, Point2D out) {
        float x1 = (float)down.getX();
        float y1 = (float)down.getY();
        float x2 = (float)out.getX();
        float y2 = (float)out.getY();
        AffineTransform xform = AffineTransform.getTranslateInstance(x2, y2);
        float dx = x2 - x1;
        float dy = y2 - y1;
        float thetaRadians = (float)Math.atan2(dy, dx);
        xform.rotate(thetaRadians);
        this.arrowShape = xform.createTransformedShape(this.rawArrowShape);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(this.cursor);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    class ArrowPaintable
    implements VisualizationServer.Paintable {
        ArrowPaintable() {
        }

        public void paint(Graphics g) {
            if (EditingGraphMousePlugin.this.arrowShape != null) {
                Color oldColor = g.getColor();
                g.setColor(Color.black);
                ((Graphics2D)g).fill(EditingGraphMousePlugin.this.arrowShape);
                g.setColor(oldColor);
            }
        }

        public boolean useTransform() {
            return false;
        }
    }

    class EdgePaintable
    implements VisualizationServer.Paintable {
        EdgePaintable() {
        }

        public void paint(Graphics g) {
            if (EditingGraphMousePlugin.this.edgeShape != null) {
                Color oldColor = g.getColor();
                g.setColor(Color.black);
                ((Graphics2D)g).draw(EditingGraphMousePlugin.this.edgeShape);
                g.setColor(oldColor);
            }
        }

        public boolean useTransform() {
            return false;
        }
    }
}

