/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl;

import io.zeebe.transport.ServerOutput;
import io.zeebe.transport.ServerResponse;
import io.zeebe.transport.impl.sender.OutgoingMessage;
import io.zeebe.transport.impl.sender.Sender;
import io.zeebe.transport.impl.sender.TransportHeaderWriter;
import io.zeebe.util.buffer.BufferWriter;
import java.nio.ByteBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class ServerOutputImpl
implements ServerOutput {
    private static final long NO_RETRIES = 0L;
    private final Sender sender;

    public ServerOutputImpl(Sender sender) {
        this.sender = sender;
    }

    @Override
    public boolean sendMessage(int remoteStreamId, BufferWriter writer) {
        int framedMessageLength = TransportHeaderWriter.getFramedMessageLength(writer.getLength());
        ByteBuffer allocatedBuffer = this.sender.allocateMessageBuffer(framedMessageLength);
        if (allocatedBuffer != null) {
            try {
                UnsafeBuffer bufferView = new UnsafeBuffer(allocatedBuffer);
                TransportHeaderWriter headerWriter = new TransportHeaderWriter();
                headerWriter.wrapMessage((MutableDirectBuffer)bufferView, writer, remoteStreamId);
                OutgoingMessage outgoingMessage = new OutgoingMessage(remoteStreamId, (MutableDirectBuffer)bufferView, 0L);
                this.sender.submitMessage(outgoingMessage);
                return true;
            }
            catch (RuntimeException e) {
                this.sender.reclaimMessageBuffer(allocatedBuffer);
                throw e;
            }
        }
        return false;
    }

    @Override
    public boolean sendResponse(ServerResponse response) {
        BufferWriter writer = response.getWriter();
        int framedLength = TransportHeaderWriter.getFramedRequestLength(writer.getLength());
        ByteBuffer allocatedBuffer = this.sender.allocateMessageBuffer(framedLength);
        if (allocatedBuffer != null) {
            try {
                int remoteStreamId = response.getRemoteStreamId();
                long requestId = response.getRequestId();
                UnsafeBuffer bufferView = new UnsafeBuffer(allocatedBuffer);
                TransportHeaderWriter headerWriter = new TransportHeaderWriter();
                headerWriter.wrapRequest((MutableDirectBuffer)bufferView, writer);
                headerWriter.setStreamId(remoteStreamId).setRequestId(requestId);
                OutgoingMessage outgoingMessage = new OutgoingMessage(remoteStreamId, (MutableDirectBuffer)bufferView, 0L);
                this.sender.submitMessage(outgoingMessage);
                return true;
            }
            catch (RuntimeException e) {
                this.sender.reclaimMessageBuffer(allocatedBuffer);
                throw e;
            }
        }
        return false;
    }
}

