/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl;

import io.zeebe.transport.ClientOutput;
import io.zeebe.transport.ClientResponse;
import io.zeebe.transport.EndpointRegistry;
import io.zeebe.transport.RemoteAddress;
import io.zeebe.transport.impl.sender.OutgoingMessage;
import io.zeebe.transport.impl.sender.OutgoingRequest;
import io.zeebe.transport.impl.sender.Sender;
import io.zeebe.transport.impl.sender.TransportHeaderWriter;
import io.zeebe.util.buffer.BufferWriter;
import io.zeebe.util.sched.clock.ActorClock;
import io.zeebe.util.sched.future.ActorFuture;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class ClientOutputImpl
implements ClientOutput {
    protected final EndpointRegistry endpointRegistry;
    protected final Sender requestManager;
    protected final Duration defaultRequestRetryTimeout;
    protected final long defaultMessageRetryTimeoutInMillis;

    public ClientOutputImpl(EndpointRegistry endpointRegistry, Sender requestManager, Duration defaultRequestRetryTimeout, Duration defaultMessageRetryTimeout) {
        this.endpointRegistry = endpointRegistry;
        this.requestManager = requestManager;
        this.defaultRequestRetryTimeout = defaultRequestRetryTimeout;
        this.defaultMessageRetryTimeoutInMillis = defaultMessageRetryTimeout.toMillis();
    }

    @Override
    public boolean sendMessage(Integer nodeId, BufferWriter writer) {
        RemoteAddress remoteAddress = this.endpointRegistry.getEndpoint(nodeId);
        if (remoteAddress != null) {
            return this.sendTransportMessage(remoteAddress.getStreamId(), writer);
        }
        return false;
    }

    private boolean sendTransportMessage(int remoteStreamId, BufferWriter writer) {
        int framedMessageLength = TransportHeaderWriter.getFramedMessageLength(writer.getLength());
        ByteBuffer allocatedBuffer = this.requestManager.allocateMessageBuffer(framedMessageLength);
        if (allocatedBuffer != null) {
            try {
                UnsafeBuffer bufferView = new UnsafeBuffer(allocatedBuffer);
                TransportHeaderWriter headerWriter = new TransportHeaderWriter();
                headerWriter.wrapMessage((MutableDirectBuffer)bufferView, writer, remoteStreamId);
                long deadline = ActorClock.currentTimeMillis() + this.defaultMessageRetryTimeoutInMillis;
                OutgoingMessage outgoingMessage = new OutgoingMessage(remoteStreamId, (MutableDirectBuffer)bufferView, deadline);
                this.requestManager.submitMessage(outgoingMessage);
                return true;
            }
            catch (RuntimeException e) {
                this.requestManager.reclaimMessageBuffer(allocatedBuffer);
                throw e;
            }
        }
        return false;
    }

    @Override
    public ActorFuture<ClientResponse> sendRequest(Integer nodeId, BufferWriter writer) {
        return this.sendRequest(nodeId, writer, this.defaultRequestRetryTimeout);
    }

    @Override
    public ActorFuture<ClientResponse> sendRequest(Integer nodeId, BufferWriter writer, Duration timeout) {
        return this.sendRequestWithRetry(() -> nodeId, b -> false, writer, timeout);
    }

    @Override
    public ActorFuture<ClientResponse> sendRequestWithRetry(Supplier<Integer> nodeIdSupplier, Predicate<DirectBuffer> responseInspector, BufferWriter writer, Duration timeout) {
        int messageLength = writer.getLength();
        int framedLength = TransportHeaderWriter.getFramedRequestLength(messageLength);
        ByteBuffer allocatedBuffer = this.requestManager.allocateRequestBuffer(framedLength);
        if (allocatedBuffer != null) {
            try {
                UnsafeBuffer bufferView = new UnsafeBuffer(allocatedBuffer);
                OutgoingRequest request = new OutgoingRequest(() -> this.endpointRegistry.getEndpoint((Integer)nodeIdSupplier.get()), responseInspector, bufferView, timeout);
                request.getHeaderWriter().wrapRequest((MutableDirectBuffer)bufferView, writer);
                return this.requestManager.submitRequest(request);
            }
            catch (RuntimeException e) {
                this.requestManager.reclaimRequestBuffer(allocatedBuffer);
                throw e;
            }
        }
        return null;
    }
}

