/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport;

import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.transport.ClientInputMessageSubscription;
import io.zeebe.transport.ClientMessageHandler;
import io.zeebe.transport.ClientOutput;
import io.zeebe.transport.EndpointRegistry;
import io.zeebe.transport.RemoteAddress;
import io.zeebe.transport.RemoteAddressList;
import io.zeebe.transport.SocketAddress;
import io.zeebe.transport.TransportListener;
import io.zeebe.transport.impl.TransportContext;
import io.zeebe.transport.impl.actor.ActorContext;
import io.zeebe.util.sched.future.ActorFuture;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ClientTransport
implements AutoCloseable {
    public static final int UNKNOWN_NODE_ID = -1;
    private final ClientOutput output;
    private final RemoteAddressList remoteAddressList;
    private final EndpointRegistry endpointRegistry;
    private final ActorContext transportActorContext;
    private final Dispatcher receiveBuffer;
    private final TransportContext transportContext;

    public ClientTransport(ActorContext transportActorContext, TransportContext transportContext) {
        this.transportActorContext = transportActorContext;
        this.transportContext = transportContext;
        this.output = transportContext.getClientOutput();
        this.remoteAddressList = transportContext.getRemoteAddressList();
        this.endpointRegistry = transportContext.getEndpointRegistry();
        this.receiveBuffer = transportContext.getReceiveBuffer();
    }

    public ClientOutput getOutput() {
        return this.output;
    }

    public void registerEndpoint(int nodeId, SocketAddress socketAddress) {
        this.endpointRegistry.setEndpoint(nodeId, socketAddress);
    }

    public RemoteAddress getEndpoint(int nodeId) {
        return this.endpointRegistry.getEndpoint(nodeId);
    }

    public void deactivateEndpoint(int nodeId) {
        this.endpointRegistry.removeEndpoint(nodeId);
    }

    public void retireEndpoint(int nodeId) {
        this.endpointRegistry.retire(nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEndpointAndAwaitChannel(int nodeId, final SocketAddress addr) {
        RemoteAddress remoteAddress = this.getRemoteAddress(addr);
        if (remoteAddress == null) {
            final ReentrantLock lock = new ReentrantLock();
            final Condition connectionEstablished = lock.newCondition();
            lock.lock();
            try {
                TransportListener listener = new TransportListener(){

                    @Override
                    public void onConnectionEstablished(RemoteAddress remoteAddress) {
                        lock.lock();
                        try {
                            if (remoteAddress.getAddress().equals(addr)) {
                                connectionEstablished.signal();
                                ClientTransport.this.removeChannelListener(this);
                            }
                        }
                        finally {
                            lock.unlock();
                        }
                    }

                    @Override
                    public void onConnectionClosed(RemoteAddress remoteAddress) {
                    }
                };
                this.transportActorContext.registerListener(listener).join();
                this.registerEndpoint(nodeId, addr);
                try {
                    if (!connectionEstablished.await(10L, TimeUnit.SECONDS)) {
                        throw new RuntimeException(new TimeoutException());
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private RemoteAddress getRemoteAddress(SocketAddress addr) {
        return this.remoteAddressList.getByAddress(addr);
    }

    public ActorFuture<ClientInputMessageSubscription> openSubscription(String subscriptionName, ClientMessageHandler messageHandler) {
        if (this.receiveBuffer == null) {
            throw new RuntimeException("Cannot throw exception. No receive buffer in use");
        }
        return this.transportActorContext.getClientConductor().openClientInputMessageSubscription(subscriptionName, messageHandler, this.output, this.remoteAddressList);
    }

    public ActorFuture<Void> registerChannelListener(TransportListener channelListener) {
        return this.transportActorContext.registerListener(channelListener);
    }

    public void removeChannelListener(TransportListener listener) {
        this.transportActorContext.removeListener(listener);
    }

    public ActorFuture<Void> closeAsync() {
        return this.transportActorContext.onClose();
    }

    @Override
    public void close() {
        this.closeAsync().join();
    }

    public void interruptAllChannels() {
        this.transportActorContext.interruptAllChannels();
    }

    public ActorFuture<Void> closeAllChannels() {
        return this.transportActorContext.closeAllOpenChannels();
    }

    public Duration getChannelKeepAlivePeriod() {
        return this.transportContext.getChannelKeepAlivePeriod();
    }
}

