/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.test.util.record;

import io.zeebe.protocol.record.Record;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import io.zeebe.protocol.record.value.BpmnElementType;
import io.zeebe.protocol.record.value.WorkflowInstanceRecordValue;
import io.zeebe.test.util.record.ExporterRecordStream;
import java.util.stream.Stream;

public class WorkflowInstanceRecordStream
extends ExporterRecordStream<WorkflowInstanceRecordValue, WorkflowInstanceRecordStream> {
    public WorkflowInstanceRecordStream(Stream<Record<WorkflowInstanceRecordValue>> stream) {
        super(stream);
    }

    @Override
    protected WorkflowInstanceRecordStream supply(Stream<Record<WorkflowInstanceRecordValue>> stream) {
        return new WorkflowInstanceRecordStream(stream);
    }

    public WorkflowInstanceRecordStream withBpmnProcessId(String bpmnProcessId) {
        return (WorkflowInstanceRecordStream)this.valueFilter(v -> bpmnProcessId.equals(v.getBpmnProcessId()));
    }

    public WorkflowInstanceRecordStream withVersion(int version) {
        return (WorkflowInstanceRecordStream)this.valueFilter(v -> v.getVersion() == version);
    }

    public WorkflowInstanceRecordStream withWorkflowKey(long workflowKey) {
        return (WorkflowInstanceRecordStream)this.valueFilter(v -> v.getWorkflowKey() == workflowKey);
    }

    public WorkflowInstanceRecordStream withWorkflowInstanceKey(long workflowInstanceKey) {
        return (WorkflowInstanceRecordStream)this.valueFilter(v -> v.getWorkflowInstanceKey() == workflowInstanceKey);
    }

    public WorkflowInstanceRecordStream withElementId(String elementId) {
        return (WorkflowInstanceRecordStream)this.valueFilter(v -> elementId.equals(v.getElementId()));
    }

    public WorkflowInstanceRecordStream withFlowScopeKey(long flowScopeKey) {
        return (WorkflowInstanceRecordStream)this.valueFilter(v -> v.getFlowScopeKey() == flowScopeKey);
    }

    public WorkflowInstanceRecordStream limitToWorkflowInstanceCompleted() {
        return (WorkflowInstanceRecordStream)this.limit(r -> r.getIntent() == WorkflowInstanceIntent.ELEMENT_COMPLETED && r.getKey() == ((WorkflowInstanceRecordValue)r.getValue()).getWorkflowInstanceKey());
    }

    public WorkflowInstanceRecordStream limitToWorkflowInstanceTerminated() {
        return (WorkflowInstanceRecordStream)this.limit(r -> r.getIntent() == WorkflowInstanceIntent.ELEMENT_TERMINATED && r.getKey() == ((WorkflowInstanceRecordValue)r.getValue()).getWorkflowInstanceKey());
    }

    public WorkflowInstanceRecordStream withElementType(BpmnElementType elementType) {
        return (WorkflowInstanceRecordStream)this.valueFilter(v -> v.getBpmnElementType() == elementType);
    }

    public WorkflowInstanceRecordStream filterRootScope() {
        return (WorkflowInstanceRecordStream)this.filter((T r) -> r.getKey() == ((WorkflowInstanceRecordValue)r.getValue()).getWorkflowInstanceKey());
    }
}

