/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.test.util.record;

import io.zeebe.protocol.record.Record;
import io.zeebe.protocol.record.intent.WorkflowInstanceCreationIntent;
import io.zeebe.protocol.record.value.WorkflowInstanceCreationRecordValue;
import io.zeebe.test.util.collection.Maps;
import io.zeebe.test.util.record.ExporterRecordStream;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class WorkflowInstanceCreationRecordStream
extends ExporterRecordStream<WorkflowInstanceCreationRecordValue, WorkflowInstanceCreationRecordStream> {
    public WorkflowInstanceCreationRecordStream(Stream<Record<WorkflowInstanceCreationRecordValue>> wrappedStream) {
        super(wrappedStream);
    }

    @Override
    protected WorkflowInstanceCreationRecordStream supply(Stream<Record<WorkflowInstanceCreationRecordValue>> wrappedStream) {
        return new WorkflowInstanceCreationRecordStream(wrappedStream);
    }

    public WorkflowInstanceCreationRecordStream withBpmnProcessId(String bpmnProcessId) {
        return (WorkflowInstanceCreationRecordStream)this.valueFilter(v -> v.getBpmnProcessId().equals(bpmnProcessId));
    }

    public WorkflowInstanceCreationRecordStream withVersion(int version) {
        return (WorkflowInstanceCreationRecordStream)this.valueFilter(v -> v.getVersion() == version);
    }

    public WorkflowInstanceCreationRecordStream withKey(long key) {
        return (WorkflowInstanceCreationRecordStream)this.valueFilter(v -> v.getWorkflowKey() == key);
    }

    public WorkflowInstanceCreationRecordStream withInstanceKey(long instanceKey) {
        return (WorkflowInstanceCreationRecordStream)this.valueFilter(v -> v.getWorkflowInstanceKey() == instanceKey);
    }

    public WorkflowInstanceCreationRecordStream withVariables(Map<String, Object> variables) {
        return (WorkflowInstanceCreationRecordStream)this.valueFilter(v -> v.getVariables().equals(variables));
    }

    public WorkflowInstanceCreationRecordStream withVariables(Map.Entry<String, Object> ... entries) {
        return this.withVariables(Maps.of(entries));
    }

    public WorkflowInstanceCreationRecordStream withVariables(Predicate<Map<String, Object>> matcher) {
        return (WorkflowInstanceCreationRecordStream)this.valueFilter(v -> matcher.test(v.getVariables()));
    }

    public WorkflowInstanceCreationRecordStream limitToWorkflowInstanceCreated(long workflowInstanceKey) {
        return (WorkflowInstanceCreationRecordStream)this.limit(r -> r.getIntent() == WorkflowInstanceCreationIntent.CREATED && ((WorkflowInstanceCreationRecordValue)r.getValue()).getWorkflowInstanceKey() == workflowInstanceKey);
    }
}

