/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.test.util.record;

import io.zeebe.protocol.record.Record;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import io.zeebe.test.util.record.ExporterRecordStream;
import io.zeebe.test.util.record.TimerRecordStream;
import io.zeebe.test.util.record.VariableDocumentRecordStream;
import io.zeebe.test.util.record.VariableRecordStream;
import io.zeebe.test.util.record.WorkflowInstanceRecordStream;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class RecordStream
extends ExporterRecordStream<RecordValue, RecordStream> {
    public RecordStream(Stream<Record<RecordValue>> wrappedStream) {
        super(wrappedStream);
    }

    @Override
    protected RecordStream supply(Stream<Record<RecordValue>> wrappedStream) {
        return new RecordStream(wrappedStream);
    }

    public RecordStream between(long lowerBoundPosition, long upperBoundPosition) {
        return this.between((Record<?> r) -> r.getPosition() > lowerBoundPosition, (Record<?> r) -> r.getPosition() >= upperBoundPosition);
    }

    public RecordStream between(Record<?> lowerBound, Record<?> upperBound) {
        return this.between(lowerBound::equals, upperBound::equals);
    }

    public RecordStream between(Predicate<Record<?>> lowerBound, Predicate<Record<?>> upperBound) {
        return (RecordStream)((RecordStream)this.limit(upperBound::test)).skipUntil(lowerBound::test);
    }

    public RecordStream limitToWorkflowInstance(long workflowInstanceKey) {
        return this.between((Record<?> r) -> r.getIntent() == WorkflowInstanceIntent.ELEMENT_ACTIVATING && r.getKey() == workflowInstanceKey, (Record<?> r) -> r.getIntent() == WorkflowInstanceIntent.ELEMENT_COMPLETED && r.getKey() == workflowInstanceKey);
    }

    public WorkflowInstanceRecordStream workflowInstanceRecords() {
        return new WorkflowInstanceRecordStream(((RecordStream)this.filter((T r) -> r.getValueType() == ValueType.WORKFLOW_INSTANCE)).map(Record.class::cast));
    }

    public TimerRecordStream timerRecords() {
        return new TimerRecordStream(((RecordStream)this.filter((T r) -> r.getValueType() == ValueType.TIMER)).map(Record.class::cast));
    }

    public VariableDocumentRecordStream variableDocumentRecords() {
        return new VariableDocumentRecordStream(((RecordStream)this.filter((T r) -> r.getValueType() == ValueType.VARIABLE_DOCUMENT)).map(Record.class::cast));
    }

    public VariableRecordStream variableRecords() {
        return new VariableRecordStream(((RecordStream)this.filter((T r) -> r.getValueType() == ValueType.VARIABLE)).map(Record.class::cast));
    }
}

