/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.test.util.record;

import io.zeebe.protocol.record.Record;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.RecordValue;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.test.util.stream.StreamWrapper;
import java.util.function.Predicate;
import java.util.stream.Stream;

public abstract class ExporterRecordStream<T extends RecordValue, S extends ExporterRecordStream<T, S>>
extends StreamWrapper<Record<T>, S> {
    public ExporterRecordStream(Stream<Record<T>> wrappedStream) {
        super(wrappedStream);
    }

    public S valueFilter(Predicate<T> predicate) {
        return (S)((ExporterRecordStream)this.filter((T r) -> predicate.test(r.getValue())));
    }

    public S onlyCommands() {
        return (S)((ExporterRecordStream)this.filter((T m) -> m.getRecordType() == RecordType.COMMAND));
    }

    public S onlyCommandRejections() {
        return (S)((ExporterRecordStream)this.filter((T m) -> m.getRecordType() == RecordType.COMMAND_REJECTION));
    }

    public S onlyEvents() {
        return (S)((ExporterRecordStream)this.filter((T m) -> m.getRecordType() == RecordType.EVENT));
    }

    public S withPosition(long position) {
        return (S)((ExporterRecordStream)this.filter((T r) -> r.getPosition() == position));
    }

    public S withSourceRecordPosition(long sourceRecordPosition) {
        return (S)((ExporterRecordStream)this.filter((T r) -> r.getSourceRecordPosition() == sourceRecordPosition));
    }

    public S withRecordKey(long key) {
        return (S)((ExporterRecordStream)this.filter((T r) -> r.getKey() == key));
    }

    public S withTimestamp(long timestamp) {
        return (S)((ExporterRecordStream)this.filter((T r) -> r.getTimestamp() == timestamp));
    }

    public S withIntent(Intent intent) {
        return (S)((ExporterRecordStream)this.filter((T m) -> m.getIntent() == intent));
    }

    public S withPartitionId(int partitionId) {
        return (S)((ExporterRecordStream)this.filter((T m) -> m.getPartitionId() == partitionId));
    }

    public S withRecordType(RecordType recordType) {
        return (S)((ExporterRecordStream)this.filter((T m) -> m.getRecordType() == recordType));
    }

    public S withRejectionType(RejectionType rejectionType) {
        return (S)((ExporterRecordStream)this.filter((T m) -> m.getRejectionType() == rejectionType));
    }

    public S withRejectionReason(String rejectionReason) {
        return (S)((ExporterRecordStream)this.filter((T m) -> rejectionReason.equals(m.getRejectionReason())));
    }

    public S withValueType(ValueType valueType) {
        return (S)((ExporterRecordStream)this.filter((T m) -> m.getValueType() == valueType));
    }
}

