/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.test.util.record;

import io.zeebe.protocol.record.Record;
import io.zeebe.protocol.record.value.DeploymentRecordValue;
import io.zeebe.protocol.record.value.deployment.DeployedWorkflow;
import io.zeebe.protocol.record.value.deployment.DeploymentResource;
import io.zeebe.test.util.record.ExporterRecordStream;
import java.util.List;
import java.util.stream.Stream;

public class DeploymentRecordStream
extends ExporterRecordStream<DeploymentRecordValue, DeploymentRecordStream> {
    public DeploymentRecordStream(Stream<Record<DeploymentRecordValue>> wrappedStream) {
        super(wrappedStream);
    }

    @Override
    protected DeploymentRecordStream supply(Stream<Record<DeploymentRecordValue>> wrappedStream) {
        return new DeploymentRecordStream(wrappedStream);
    }

    public DeploymentRecordStream withResources(List<DeploymentResource> resources) {
        return (DeploymentRecordStream)this.valueFilter(v -> resources.equals(v.getResources()));
    }

    public DeploymentRecordStream withResource(DeploymentResource resource) {
        return (DeploymentRecordStream)this.valueFilter(v -> v.getResources().contains(resource));
    }

    public DeploymentRecordStream withDeployedWorkflows(List<DeployedWorkflow> deployedWorkflows) {
        return (DeploymentRecordStream)this.valueFilter(v -> deployedWorkflows.equals(v.getDeployedWorkflows()));
    }

    public DeploymentRecordStream withDeployedWorkflow(DeployedWorkflow deployedWorkflow) {
        return (DeploymentRecordStream)this.valueFilter(v -> v.getDeployedWorkflows().contains(deployedWorkflow));
    }
}

