/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.test.util.io;

import java.io.IOException;
import java.io.OutputStream;

public class RepeatedlyFailingOutputStream
extends OutputStream {
    public static final long DEFAULT_FAILURE_FREQUENCY = 8L;
    private final OutputStream underlyingOutputStream;
    private final long failureFrequency;
    private long writeCount;

    public RepeatedlyFailingOutputStream(OutputStream underlyingOutputStream) {
        this(underlyingOutputStream, 8L);
    }

    public RepeatedlyFailingOutputStream(OutputStream underlyingOutputStream, long failureFrequency) {
        this.underlyingOutputStream = underlyingOutputStream;
        this.failureFrequency = failureFrequency;
        this.writeCount = 0L;
    }

    public OutputStream getUnderlyingOutputStream() {
        return this.underlyingOutputStream;
    }

    @Override
    public void write(int b) throws IOException {
        ++this.writeCount;
        if (this.writeCount % this.failureFrequency == 0L) {
            throw new IOException("Write failure");
        }
        this.underlyingOutputStream.write(b);
    }
}

