/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.test.util;

import io.zeebe.util.ZbLogger;
import java.util.concurrent.Callable;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;

public class TestUtil {
    public static final int MAX_RETRIES = 100;
    private static final Logger LOG = new ZbLogger(TestUtil.class);

    public static <T> Invocation<T> doRepeatedly(Callable<T> callable) {
        return new Invocation<T>(callable);
    }

    public static Invocation<Void> doRepeatedly(Runnable runnable) {
        return new Invocation<Void>(() -> {
            runnable.run();
            return null;
        });
    }

    public static void waitUntil(BooleanSupplier condition) {
        TestUtil.doRepeatedly(() -> null).until(r -> condition.getAsBoolean());
    }

    public static void waitUntil(BooleanSupplier condition, String message, Object ... args) {
        TestUtil.doRepeatedly(() -> null).until(r -> condition.getAsBoolean(), message, args);
    }

    public static void waitUntil(BooleanSupplier condition, int retries) {
        TestUtil.doRepeatedly(() -> null).until(r -> condition.getAsBoolean(), retries);
    }

    public static void waitUntil(BooleanSupplier condition, int retries, String message, Object ... args) {
        TestUtil.doRepeatedly(() -> null).until(r -> condition.getAsBoolean(), retries, message, args);
    }

    public static class Invocation<T> {
        protected Callable<T> callable;

        public Invocation(Callable<T> callable) {
            this.callable = callable;
        }

        public T until(Function<T, Boolean> resultCondition) {
            return this.until(resultCondition, e -> false);
        }

        public T until(Function<T, Boolean> resultCondition, String message, Object ... args) {
            return this.until(resultCondition, (Exception e) -> false, message, args);
        }

        public T until(Function<T, Boolean> resultCondition, int retries) {
            return this.until(resultCondition, (Exception e) -> false, retries);
        }

        public T until(Function<T, Boolean> resultCondition, int retries, String message, Object ... args) {
            return this.until(resultCondition, (Exception e) -> false, retries, message, args);
        }

        public T until(Function<T, Boolean> resultCondition, Function<Exception, Boolean> exceptionCondition) {
            Object result = this.whileConditionHolds((T t) -> (Boolean)resultCondition.apply(t) == false, e -> (Boolean)exceptionCondition.apply((Exception)e) == false);
            Assertions.assertThat((Boolean)resultCondition.apply(result)).isTrue();
            return (T)result;
        }

        public T until(Function<T, Boolean> resultCondition, Function<Exception, Boolean> exceptionCondition, String message, Object ... args) {
            Object result = this.whileConditionHolds((T t) -> (Boolean)resultCondition.apply(t) == false, e -> (Boolean)exceptionCondition.apply((Exception)e) == false);
            ((AbstractBooleanAssert)Assertions.assertThat((Boolean)resultCondition.apply(result)).withFailMessage(message, args)).isTrue();
            return (T)result;
        }

        public T until(Function<T, Boolean> resultCondition, Function<Exception, Boolean> exceptionCondition, int retries) {
            Object result = this.whileConditionHolds(t -> (Boolean)resultCondition.apply(t) == false, e -> (Boolean)exceptionCondition.apply((Exception)e) == false, retries);
            Assertions.assertThat((Boolean)resultCondition.apply(result)).isTrue();
            return (T)result;
        }

        public T until(Function<T, Boolean> resultCondition, Function<Exception, Boolean> exceptionCondition, int retries, String message, Object ... args) {
            Object result = this.whileConditionHolds(t -> (Boolean)resultCondition.apply(t) == false, e -> (Boolean)exceptionCondition.apply((Exception)e) == false, retries);
            ((AbstractBooleanAssert)Assertions.assertThat((Boolean)resultCondition.apply(result)).withFailMessage(message, args)).isTrue();
            return (T)result;
        }

        public T whileConditionHolds(Function<T, Boolean> resultCondition) {
            return this.whileConditionHolds(resultCondition, e -> true);
        }

        public T whileConditionHolds(Function<T, Boolean> resultCondition, int retires) {
            return this.whileConditionHolds(resultCondition, e -> true, retires);
        }

        public T whileConditionHolds(Function<T, Boolean> resultCondition, Function<Exception, Boolean> exceptionCondition) {
            return this.whileConditionHolds(resultCondition, exceptionCondition, 100);
        }

        public T whileConditionHolds(Function<T, Boolean> resultCondition, Function<Exception, Boolean> exceptionCondition, int retries) {
            Object result;
            int numTries = 0;
            do {
                result = null;
                try {
                    if (numTries > 0) {
                        Thread.sleep(100L);
                    }
                    result = this.callable.call();
                }
                catch (Exception e) {
                    if (!exceptionCondition.apply(e).booleanValue()) {
                        throw new RuntimeException("Unexpected exception while checking condition", e);
                    }
                    LOG.error("Exception caught, will retry.", (Throwable)e);
                }
            } while (++numTries < retries && resultCondition.apply(result).booleanValue());
            return result;
        }
    }
}

