/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.test.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.regex.Matcher;

public class TestFileUtil {
    public static InputStream readAsTextFileAndReplace(InputStream inputStream, Charset charset, Map<String, String> properties) {
        String fileContent;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, charset));){
            StringBuilder sb = new StringBuilder();
            reader.lines().forEach(line -> {
                String replacingLine = line;
                for (Map.Entry replacement : properties.entrySet()) {
                    String property = "\\$\\{" + (String)replacement.getKey() + "\\}";
                    replacingLine = replacingLine.replaceAll(property, Matcher.quoteReplacement((String)replacement.getValue()));
                }
                sb.append(replacingLine);
                sb.append("\n");
            });
            fileContent = sb.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ByteArrayInputStream(fileContent.getBytes(charset));
    }
}

