/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.test.util;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public class Stopwatch {
    protected List<Checkpoint> checkpoints = new ArrayList<Checkpoint>();

    public void record(String checkpoint) {
        System.out.println(checkpoint);
        Checkpoint c = new Checkpoint();
        c.name = checkpoint;
        c.timestamp = System.currentTimeMillis();
        this.checkpoints.add(c);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nStopwatch results:\n");
        if (this.checkpoints.size() >= 2) {
            for (int i = 1; i < this.checkpoints.size(); ++i) {
                Checkpoint from = this.checkpoints.get(i - 1);
                Checkpoint to = this.checkpoints.get(i);
                sb.append("From ");
                sb.append(from.name);
                sb.append(" to ");
                sb.append(to.name);
                sb.append(": ");
                sb.append(Duration.ofMillis(to.timestamp - from.timestamp));
                sb.append("\n");
            }
        } else {
            sb.append("Needs at least two checkpoints");
        }
        sb.append("\n");
        return sb.toString();
    }

    protected static class Checkpoint {
        String name;
        long timestamp;

        protected Checkpoint() {
        }
    }
}

