/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.test.util;

import io.zeebe.util.ReflectUtil;
import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.Assertions;

public class BufferWriterUtil {
    public static <T extends BufferWriter & BufferReader> void assertEqualFieldsAfterWriteAndRead(T writer, String ... fieldNames) {
        T reader = BufferWriterUtil.writeAndRead(writer);
        Assertions.assertThat(reader).isEqualToComparingOnlyGivenFields(writer, fieldNames);
    }

    public static <T extends BufferWriter & BufferReader> T writeAndRead(T writer) {
        BufferWriter reader = (BufferWriter)ReflectUtil.newInstance(writer.getClass());
        BufferWriterUtil.wrap(writer, (BufferReader)reader);
        return (T)reader;
    }

    public static void wrap(BufferWriter writer, BufferReader reader) {
        UnsafeBuffer buffer = new UnsafeBuffer(new byte[writer.getLength()]);
        writer.write((MutableDirectBuffer)buffer, 0);
        reader.wrap((DirectBuffer)buffer, 0, buffer.capacity());
    }

    public static <T extends BufferReader> T wrap(BufferWriter writer, Class<T> readerClass) {
        BufferReader reader = (BufferReader)ReflectUtil.newInstance(readerClass);
        BufferWriterUtil.wrap(writer, reader);
        return (T)reader;
    }
}

