/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.servicecontainer.testing;

import io.zeebe.servicecontainer.ServiceContainer;
import io.zeebe.servicecontainer.impl.ServiceContainerImpl;
import io.zeebe.util.sched.ActorScheduler;
import io.zeebe.util.sched.testing.ActorSchedulerRule;
import io.zeebe.util.sched.testing.ControlledActorSchedulerRule;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.rules.ExternalResource;

public class ServiceContainerRule
extends ExternalResource {
    private ServiceContainerImpl serviceContainer;
    private final boolean shouldStop;
    private ActorSchedulerRule actorSchedulerRule;
    private ControlledActorSchedulerRule controlledActorSchedulerRule;

    public ServiceContainerRule(ActorSchedulerRule actorSchedulerRule, boolean shouldStop) {
        this.actorSchedulerRule = actorSchedulerRule;
        this.shouldStop = shouldStop;
    }

    public ServiceContainerRule(ControlledActorSchedulerRule controlledActorSchedulerRule, boolean shouldStop) {
        this.controlledActorSchedulerRule = controlledActorSchedulerRule;
        this.shouldStop = shouldStop;
    }

    public ServiceContainerRule(ActorSchedulerRule actorSchedulerRule) {
        this(actorSchedulerRule, true);
    }

    public ServiceContainerRule(ControlledActorSchedulerRule actorSchedulerRule) {
        this(actorSchedulerRule, false);
    }

    protected void before() throws Throwable {
        ActorScheduler actorScheduler = this.actorSchedulerRule == null ? this.controlledActorSchedulerRule.get() : this.actorSchedulerRule.get();
        this.serviceContainer = new ServiceContainerImpl(actorScheduler);
        this.serviceContainer.start();
    }

    protected void after() {
        if (this.shouldStop) {
            try {
                this.serviceContainer.close(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public ServiceContainer get() {
        return this.serviceContainer;
    }

    public ActorSchedulerRule getActorSchedulerRule() {
        return this.actorSchedulerRule;
    }
}

