/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.servicecontainer.impl;

import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceGroupReference;
import io.zeebe.servicecontainer.ServiceName;
import io.zeebe.servicecontainer.impl.ServiceController;
import io.zeebe.servicecontainer.impl.ServiceGroupReferenceImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ServiceGroup {
    protected final ServiceName<?> groupName;
    protected final List<ServiceController> controllers = new ArrayList<ServiceController>();
    protected final List<ServiceGroupReferenceImpl> references = new ArrayList<ServiceGroupReferenceImpl>();

    public ServiceGroup(ServiceName<?> groupName) {
        this.groupName = groupName;
    }

    public void addReference(ServiceGroupReferenceImpl reference) {
        this.references.add(reference);
        this.onReferenceAdded(reference);
    }

    private void onReferenceAdded(ServiceGroupReferenceImpl reference) {
        for (ServiceController serviceController : this.controllers) {
            Service service = serviceController.getService();
            reference.addValue(serviceController.getServiceName(), service.get());
        }
    }

    public void removeReference(ServiceGroupReference<?> reference) {
        Iterator<ServiceGroupReferenceImpl> iterator = this.references.iterator();
        while (iterator.hasNext()) {
            ServiceGroupReferenceImpl serviceGroupReferenceImpl = iterator.next();
            if (serviceGroupReferenceImpl.injector != reference) continue;
            serviceGroupReferenceImpl.uninject();
            iterator.remove();
            break;
        }
    }

    public void addService(ServiceController controller) {
        this.controllers.add(controller);
        this.onServiceAdded(controller);
    }

    public void removeService(ServiceController controller) {
        this.controllers.remove((Object)controller);
        this.onServiceRemoved(controller);
    }

    private void onServiceAdded(ServiceController controller) {
        Object serviceObject = controller.getService().get();
        for (int i = 0; i < this.references.size(); ++i) {
            ServiceGroupReferenceImpl reference = this.references.get(i);
            reference.addValue(controller.getServiceName(), serviceObject);
        }
    }

    private void onServiceRemoved(ServiceController controller) {
        Object serviceObject = controller.getService().get();
        for (int i = 0; i < this.references.size(); ++i) {
            ServiceGroupReferenceImpl reference = this.references.get(i);
            reference.removeValue(controller.getServiceName(), serviceObject);
        }
    }

    public List<ServiceController> getControllers() {
        return this.controllers;
    }
}

