/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.servicecontainer.impl;

import io.zeebe.servicecontainer.CompositeServiceBuilder;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceBuilder;
import io.zeebe.servicecontainer.ServiceContainer;
import io.zeebe.servicecontainer.ServiceInterruptedException;
import io.zeebe.servicecontainer.ServiceName;
import io.zeebe.servicecontainer.impl.Loggers;
import io.zeebe.servicecontainer.impl.ServiceController;
import io.zeebe.servicecontainer.impl.ServiceDependencyResolver;
import io.zeebe.servicecontainer.impl.ServiceEvent;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorScheduler;
import io.zeebe.util.sched.channel.ConcurrentQueueChannel;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.concurrent.ManyToOneConcurrentLinkedQueue;
import org.slf4j.Logger;

public class ServiceContainerImpl
extends Actor
implements ServiceContainer {
    public static final Logger LOG = Loggers.SERVICE_CONTAINER_LOGGER;
    private static final String NAME = "service-container-main";
    protected final ServiceDependencyResolver dependencyResolver = new ServiceDependencyResolver();
    protected final ConcurrentQueueChannel<ServiceEvent> channel = new ConcurrentQueueChannel((Queue)new ManyToOneConcurrentLinkedQueue());
    protected final ActorScheduler actorScheduler;
    protected ContainerState state = ContainerState.NEW;
    protected final AtomicBoolean isOpenend = new AtomicBoolean(false);
    private final CompletableActorFuture<Void> containerCloseFuture = new CompletableActorFuture();

    public ServiceContainerImpl(ActorScheduler scheduler) {
        this.actorScheduler = scheduler;
    }

    @Override
    public void start() {
        if (!this.isOpenend.compareAndSet(false, true)) {
            String errorMessage = String.format("Cannot start service container, is already open.", new Object[0]);
            throw new IllegalStateException(errorMessage);
        }
        this.actorScheduler.submitActor((Actor)this);
        this.state = ContainerState.OPEN;
    }

    public String getName() {
        return NAME;
    }

    protected void onActorStarted() {
        this.actor.consume(this.channel, this::onServiceEvent);
    }

    protected void onServiceEvent() {
        ServiceEvent serviceEvent = (ServiceEvent)this.channel.poll();
        if (serviceEvent != null) {
            LOG.trace("{}", (Object)serviceEvent);
            this.dependencyResolver.onServiceEvent(serviceEvent);
        } else {
            this.actor.yield();
        }
    }

    @Override
    public ActorFuture<Boolean> hasService(ServiceName<?> name) {
        return this.actor.call(() -> this.hasServiceInternal(name));
    }

    private boolean hasServiceInternal(ServiceName<?> name) {
        return this.dependencyResolver.getService(name) != null;
    }

    @Override
    public <S> ServiceBuilder<S> createService(ServiceName<S> name, Service<S> service) {
        return new ServiceBuilder<S>(name, service, this);
    }

    @Override
    public CompositeServiceBuilder createComposite(ServiceName<Void> name) {
        return new CompositeServiceBuilder(name, this, new ServiceName[0]);
    }

    public <S> ActorFuture<S> onServiceBuilt(ServiceBuilder<S> serviceBuilder) {
        CompletableActorFuture future = new CompletableActorFuture();
        this.actor.run(() -> {
            ServiceName serviceName = serviceBuilder.getName();
            if (this.state == ContainerState.OPEN) {
                ServiceController serviceController = new ServiceController(serviceBuilder, this, future);
                if (!this.hasServiceInternal(serviceController.getServiceName())) {
                    this.actorScheduler.submitActor((Actor)serviceController);
                } else {
                    String errorMessage = String.format("Cannot install service with name '%s'. Service with same name already exists", serviceName);
                    future.completeExceptionally((Throwable)new IllegalStateException(errorMessage));
                }
            } else {
                String errorMessage = String.format("Cannot install new service %s into the container, state is '%s'", new Object[]{serviceName, this.state});
                future.completeExceptionally((Throwable)new IllegalStateException(errorMessage));
            }
            this.actor.runOnCompletion((ActorFuture)future, (r, t) -> {
                if (t != null) {
                    if (t instanceof ServiceInterruptedException) {
                        LOG.debug(String.format("Service %s interrupted while building", serviceName.getName()));
                    } else {
                        LOG.error("Failed to build service", t);
                    }
                }
            });
        });
        return future;
    }

    @Override
    public ActorFuture<Void> removeService(ServiceName<?> serviceName) {
        CompletableActorFuture future = new CompletableActorFuture();
        this.actor.call(() -> {
            if (this.state == ContainerState.OPEN || this.state == ContainerState.CLOSING) {
                ServiceController ctrl = this.dependencyResolver.getService(serviceName);
                if (ctrl != null) {
                    this.actor.runOnCompletion(ctrl.remove(), (v, t) -> {
                        if (t != null) {
                            future.completeExceptionally(t);
                        } else {
                            future.complete(null);
                        }
                    });
                } else {
                    future.complete(null);
                }
            } else {
                String errorMessage = String.format("Cannot remove service, container is '%s'.", new Object[]{this.state});
                future.completeExceptionally((Throwable)new IllegalStateException(errorMessage));
            }
            this.actor.runOnCompletion((ActorFuture)future, (r, t) -> {
                if (t != null) {
                    LOG.error("Failed to remove service {}: {}", (Object)serviceName, t);
                }
            });
        });
        return future;
    }

    @Override
    public void close(long awaitTime, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        ActorFuture<Void> containerCloseFuture = this.closeAsync();
        try {
            containerCloseFuture.get(awaitTime, timeUnit);
        }
        catch (Exception ex) {
            LOG.debug("Service container closing failed. Print dependencies.");
            StringBuilder builder = new StringBuilder();
            this.dependencyResolver.getControllers().forEach(c -> {
                builder.append("\n").append(c).append("\n\t\\");
                c.getDependencies().forEach(d -> builder.append("\n \t-- ").append((Object)this.dependencyResolver.getService((ServiceName<?>)d)));
            });
            LOG.debug(builder.toString());
            throw ex;
        }
        finally {
            this.onClosed();
        }
    }

    @Override
    public ActorFuture<Void> closeAsync() {
        this.actor.call(() -> {
            if (this.state == ContainerState.OPEN) {
                this.state = ContainerState.CLOSING;
                ArrayList serviceFutures = new ArrayList();
                this.dependencyResolver.getRootServices().forEach(c -> {
                    ActorFuture<Void> removeFuture = c.remove();
                    this.actor.runOnCompletion(removeFuture, (v, t) -> LOG.debug("Removed service {}", c.getServiceName()));
                    serviceFutures.add(removeFuture);
                });
                this.actor.runOnCompletion(serviceFutures, t -> {
                    this.actor.close();
                    this.containerCloseFuture.complete(null);
                });
            } else {
                String errorMessage = String.format("Cannot close service container, container is '%s'.", new Object[]{this.state});
                this.containerCloseFuture.completeExceptionally((Throwable)new IllegalStateException(errorMessage));
            }
        });
        return this.containerCloseFuture;
    }

    private void onClosed() {
        this.state = ContainerState.CLOSED;
    }

    public ConcurrentQueueChannel<ServiceEvent> getChannel() {
        return this.channel;
    }

    public ActorScheduler getActorScheduler() {
        return this.actorScheduler;
    }

    static enum ContainerState {
        NEW,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

