/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.servicecontainer;

import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceGroupReference;
import io.zeebe.servicecontainer.ServiceName;
import io.zeebe.servicecontainer.impl.ServiceContainerImpl;
import io.zeebe.util.sched.future.ActorFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ServiceBuilder<S> {
    protected final ServiceContainerImpl serviceContainer;
    protected final ServiceName<S> name;
    protected final Service<S> service;
    protected ServiceName<?> groupName;
    protected Set<ServiceName<?>> dependencies = new HashSet();
    protected Map<ServiceName<?>, Collection<Injector<?>>> injectedDependencies = new HashMap();
    protected Map<ServiceName<?>, ServiceGroupReference<?>> injectedReferences = new HashMap();

    public ServiceBuilder(ServiceName<S> name, Service<S> service, ServiceContainerImpl serviceContainer) {
        this.name = name;
        this.service = service;
        this.serviceContainer = serviceContainer;
    }

    public ServiceBuilder<S> group(ServiceName<?> groupName) {
        this.groupName = groupName;
        return this;
    }

    public <T> ServiceBuilder<S> dependency(ServiceName<T> serviceName) {
        this.dependencies.add(serviceName);
        return this;
    }

    public <T> ServiceBuilder<S> dependency(ServiceName<? extends T> serviceName, Injector<T> injector) {
        Collection<Injector<?>> injectors = this.injectedDependencies.get(serviceName);
        if (injectors == null) {
            injectors = new ArrayList();
        }
        injectors.add(injector);
        this.injectedDependencies.put(serviceName, injectors);
        return this.dependency(serviceName);
    }

    public <T> ServiceBuilder<S> dependency(String name, Class<T> type) {
        return this.dependency(ServiceName.newServiceName(name, type));
    }

    public <T> ServiceBuilder<S> groupReference(ServiceName<T> groupName, ServiceGroupReference<T> injector) {
        this.injectedReferences.put(groupName, injector);
        return this;
    }

    public ActorFuture<S> install() {
        return this.serviceContainer.onServiceBuilt(this);
    }

    public ServiceName<S> getName() {
        return this.name;
    }

    public Service<S> getService() {
        return this.service;
    }

    public Set<ServiceName<?>> getDependencies() {
        return this.dependencies;
    }

    public Map<ServiceName<?>, Collection<Injector<?>>> getInjectedDependencies() {
        return this.injectedDependencies;
    }

    public Map<ServiceName<?>, ServiceGroupReference<?>> getInjectedReferences() {
        return this.injectedReferences;
    }

    public ServiceName<?> getGroupName() {
        return this.groupName;
    }
}

