/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.servicecontainer;

import io.zeebe.servicecontainer.ServiceName;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;

public final class ServiceGroupReference<S> {
    private static final BiConsumer NOOP_CONSUMER = (n, v) -> {};
    protected BiConsumer<ServiceName<S>, S> addHandler;
    protected BiConsumer<ServiceName<S>, S> removeHandler;

    private ServiceGroupReference() {
        this(NOOP_CONSUMER, NOOP_CONSUMER);
    }

    private ServiceGroupReference(BiConsumer<ServiceName<S>, S> addHandler, BiConsumer<ServiceName<S>, S> removeHandler) {
        this.addHandler = addHandler;
        this.removeHandler = removeHandler;
    }

    public BiConsumer<ServiceName<S>, S> getAddHandler() {
        return this.addHandler;
    }

    public BiConsumer<ServiceName<S>, S> getRemoveHandler() {
        return this.removeHandler;
    }

    public static <S> ServiceGroupReference<S> collection(Collection<S> collection) {
        BiConsumer<ServiceName, Object> addHandler = (name, v) -> collection.add(v);
        BiConsumer<ServiceName, Object> removeHandler = (name, v) -> collection.remove(v);
        return new ServiceGroupReference<Object>(addHandler, removeHandler);
    }

    public static <S, K> ServiceGroupReference<S> map(Map<ServiceName<S>, S> map) {
        BiConsumer<ServiceName, Object> addHandler = (name, v) -> map.put((ServiceName)name, (Object)v);
        BiConsumer<ServiceName, Object> removeHandler = (name, v) -> map.remove(name, v);
        return new ServiceGroupReference<Object>(addHandler, removeHandler);
    }

    public static <S> ReferenceBuilder<S> create() {
        return new ReferenceBuilder();
    }

    public static class ReferenceBuilder<S> {
        protected final ServiceGroupReference<S> referenceCollection = new ServiceGroupReference();

        public ReferenceBuilder<S> onRemove(BiConsumer<ServiceName<S>, S> removeConsumer) {
            this.referenceCollection.removeHandler = removeConsumer;
            return this;
        }

        public ReferenceBuilder<S> onAdd(BiConsumer<ServiceName<S>, S> addConsumer) {
            this.referenceCollection.addHandler = addConsumer;
            return this;
        }

        public ServiceGroupReference<S> build() {
            return this.referenceCollection;
        }
    }
}

