/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.servicecontainer;

import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceBuilder;
import io.zeebe.servicecontainer.ServiceContainer;
import io.zeebe.servicecontainer.ServiceName;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.servicecontainer.impl.ServiceContainerImpl;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CompositeServiceBuilder {
    private final ServiceContainerImpl container;
    private final ServiceName<Void> compositeServiceName;
    private final Map<ServiceName, ActorFuture<Object>> installFutures = new HashMap<ServiceName, ActorFuture<Object>>();

    public CompositeServiceBuilder(ServiceName<Void> name, ServiceContainer container, ServiceName<?> ... additionalDependencies) {
        this.compositeServiceName = name;
        this.container = (ServiceContainerImpl)container;
        ServiceBuilder<Void> installServiceBuilder = container.createService(this.compositeServiceName, new CompositeService());
        for (ServiceName<?> serviceName : additionalDependencies) {
            installServiceBuilder.dependency(serviceName);
        }
        this.installFutures.put(this.compositeServiceName, installServiceBuilder.install());
    }

    public ActorFuture<Void> install() {
        CompletableActorFuture compositeInstallFuture = new CompletableActorFuture();
        this.container.getActorScheduler().submitActor(new CompositeInstallCompletion<Void>(compositeInstallFuture, this.compositeServiceName));
        return compositeInstallFuture;
    }

    public <S> ActorFuture<S> installAndReturn(ServiceName<S> returnedServiceName) {
        CompletableActorFuture compositeInstallFuture = new CompletableActorFuture();
        this.container.getActorScheduler().submitActor(new CompositeInstallCompletion<S>(compositeInstallFuture, returnedServiceName));
        return compositeInstallFuture;
    }

    public <S> ServiceBuilder<S> createService(ServiceName<S> name, Service<S> service) {
        return new ComposedServiceBuilder<S>(name, service, this.container);
    }

    public static ServiceName<Void> compositeServiceName(String name) {
        return ServiceName.newServiceName(String.format("%s.install", name), Void.class);
    }

    class CompositeService
    implements Service<Void> {
        CompositeService() {
        }

        @Override
        public void start(ServiceStartContext startContext) {
        }

        @Override
        public void stop(ServiceStopContext stopContext) {
        }

        @Override
        public Void get() {
            return null;
        }
    }

    class ComposedServiceBuilder<S>
    extends ServiceBuilder<S> {
        private ServiceName<S> serviceName;

        ComposedServiceBuilder(ServiceName<S> name, Service<S> service, ServiceContainerImpl serviceContainer) {
            super(name, service, serviceContainer);
            this.serviceName = name;
            this.dependency(CompositeServiceBuilder.this.compositeServiceName);
        }

        @Override
        public ActorFuture<S> install() {
            ActorFuture installFuture = super.install();
            CompositeServiceBuilder.this.installFutures.put(this.serviceName, installFuture);
            return installFuture;
        }
    }

    private final class CompositeInstallCompletion<S>
    extends Actor {
        private final CompletableActorFuture<S> future;
        private final ServiceName<S> returnedServiceName;

        CompositeInstallCompletion(CompletableActorFuture<S> future, ServiceName<S> returnedServiceName) {
            this.future = future;
            this.returnedServiceName = returnedServiceName;
        }

        protected void onActorStarted() {
            Collection allFutures = CompositeServiceBuilder.this.installFutures.values();
            for (Map.Entry futures : CompositeServiceBuilder.this.installFutures.entrySet()) {
                this.actor.runOnCompletion((ActorFuture)futures.getValue(), (val, t) -> {
                    if (t != null) {
                        this.actor.runOnCompletion(CompositeServiceBuilder.this.container.removeService(CompositeServiceBuilder.this.compositeServiceName), (v, e) -> {
                            String errorMessage = "Could not complete installation of " + CompositeServiceBuilder.this.compositeServiceName.getName() + ": Failed to install " + futures.getKey();
                            this.future.completeExceptionally((Throwable)new RuntimeException(errorMessage, (Throwable)t));
                            this.actor.close();
                        });
                    } else if (!this.future.isDone() && allFutures.stream().allMatch(f -> f.isDone())) {
                        this.future.completeWith((CompletableActorFuture)CompositeServiceBuilder.this.installFutures.get(this.returnedServiceName));
                        this.actor.close();
                    }
                });
            }
        }
    }
}

