/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.value;

import io.zeebe.msgpack.spec.MsgPackReader;
import io.zeebe.msgpack.spec.MsgPackWriter;
import io.zeebe.msgpack.value.BaseValue;
import io.zeebe.msgpack.value.StringValue;
import java.util.Objects;

public class EnumValue<E extends Enum<E>>
extends BaseValue {
    private final StringValue decodedValue = new StringValue();
    private final StringValue[] binaryEnumValues;
    private final E[] enumConstants;
    private E value;

    public EnumValue(Class<E> e, E defaultValue) {
        this.enumConstants = (Enum[])e.getEnumConstants();
        this.binaryEnumValues = new StringValue[this.enumConstants.length];
        for (int i = 0; i < this.enumConstants.length; ++i) {
            E constant = this.enumConstants[i];
            this.binaryEnumValues[i] = new StringValue(((Enum)constant).toString());
        }
        this.value = defaultValue;
    }

    public EnumValue(Class<E> e) {
        this(e, null);
    }

    public E getValue() {
        return this.value;
    }

    public void setValue(E val) {
        this.value = val;
    }

    @Override
    public void reset() {
        this.value = null;
    }

    @Override
    public void writeJSON(StringBuilder builder) {
        this.binaryEnumValues[((Enum)this.value).ordinal()].writeJSON(builder);
    }

    @Override
    public void write(MsgPackWriter writer) {
        this.binaryEnumValues[((Enum)this.value).ordinal()].write(writer);
    }

    @Override
    public void read(MsgPackReader reader) {
        this.decodedValue.read(reader);
        for (int i = 0; i < this.binaryEnumValues.length; ++i) {
            StringValue val = this.binaryEnumValues[i];
            if (!val.equals(this.decodedValue)) continue;
            this.value = this.enumConstants[i];
            return;
        }
        throw new RuntimeException(String.format("Illegal enum value: %s.", this.decodedValue.toString()));
    }

    @Override
    public int getEncodedLength() {
        return this.binaryEnumValues[((Enum)this.value).ordinal()].getEncodedLength();
    }

    public int hashCode() {
        return Objects.hash(this.getValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnumValue)) {
            return false;
        }
        EnumValue enumValue = (EnumValue)o;
        return Objects.equals(this.getValue(), enumValue.getValue());
    }
}

