/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.value;

import io.zeebe.msgpack.spec.MsgPackReader;
import io.zeebe.msgpack.spec.MsgPackWriter;
import io.zeebe.msgpack.value.BaseValue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;

public class ArrayValue<T extends BaseValue>
extends BaseValue
implements Iterator<T>,
Iterable<T> {
    private final MsgPackWriter writer = new MsgPackWriter();
    private final MsgPackReader reader = new MsgPackReader();
    private final ExpandableArrayBuffer buffer = new ExpandableArrayBuffer();
    private final T innerValue;
    private int elementCount;
    private int bufferLength;
    private int oldInnerValueLength;
    private InnerValueState innerValueState;
    private int cursorOffset;
    private int cursorIndex;

    public ArrayValue(T innerValue) {
        this.innerValue = innerValue;
        this.reset();
    }

    @Override
    public void reset() {
        this.elementCount = 0;
        this.bufferLength = 0;
        this.resetIterator();
        this.resetInnerValue();
    }

    private void resetIterator() {
        this.cursorIndex = 0;
        this.cursorOffset = 0;
    }

    private void resetInnerValue() {
        this.innerValue.reset();
        this.oldInnerValueLength = 0;
        this.innerValueState = InnerValueState.Uninitialized;
    }

    @Override
    public void writeJSON(StringBuilder builder) {
        this.flushAndResetInnerValue();
        builder.append("[");
        boolean firstElement = true;
        for (BaseValue element : this) {
            if (!firstElement) {
                builder.append(",");
            } else {
                firstElement = false;
            }
            element.writeJSON(builder);
        }
        builder.append("]");
    }

    @Override
    public void write(MsgPackWriter writer) {
        this.flushAndResetInnerValue();
        writer.writeArrayHeader(this.elementCount);
        writer.writeRaw((DirectBuffer)this.buffer, 0, this.bufferLength);
    }

    @Override
    public void read(MsgPackReader reader) {
        this.reset();
        this.elementCount = reader.readArrayHeader();
        this.writer.wrap((MutableDirectBuffer)this.buffer, 0);
        for (int i = 0; i < this.elementCount; ++i) {
            ((BaseValue)this.innerValue).read(reader);
            ((BaseValue)this.innerValue).write(this.writer);
        }
        this.resetInnerValue();
        this.bufferLength = this.writer.getOffset();
    }

    @Override
    public int getEncodedLength() {
        this.flushAndResetInnerValue();
        return MsgPackWriter.getEncodedArrayHeaderLenght((int)this.elementCount) + this.bufferLength;
    }

    @Override
    public Iterator<T> iterator() {
        this.flushAndResetInnerValue();
        this.resetIterator();
        this.resetInnerValue();
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.cursorIndex < this.elementCount;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements left");
        }
        int innerValueLength = this.getInnerValueLength();
        this.flushAndResetInnerValue();
        ++this.cursorIndex;
        this.cursorOffset += innerValueLength;
        this.readInnerValue();
        return this.innerValue;
    }

    @Override
    public void remove() {
        if (this.innerValueState != InnerValueState.Modify) {
            throw new IllegalStateException("No element available to remove, call next() before");
        }
        --this.elementCount;
        --this.cursorIndex;
        this.moveValuesLeft(this.cursorOffset + this.oldInnerValueLength, this.oldInnerValueLength);
        this.innerValueState = InnerValueState.Uninitialized;
    }

    public T add() {
        boolean elementUpdated = this.innerValueState == InnerValueState.Modify;
        int innerValueLength = this.getInnerValueLength();
        this.flushAndResetInnerValue();
        ++this.elementCount;
        if (elementUpdated) {
            this.cursorOffset += innerValueLength;
            ++this.cursorIndex;
        }
        this.innerValueState = InnerValueState.Insert;
        return this.innerValue;
    }

    public int hashCode() {
        return Objects.hash(this.buffer, this.elementCount, this.bufferLength);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayValue)) {
            return false;
        }
        ArrayValue that = (ArrayValue)o;
        return this.elementCount == that.elementCount && this.bufferLength == that.bufferLength && Objects.equals(this.buffer, that.buffer);
    }

    private int getInnerValueLength() {
        switch (this.innerValueState) {
            case Insert: 
            case Modify: {
                return ((BaseValue)this.innerValue).getEncodedLength();
            }
        }
        return 0;
    }

    private void readInnerValue() {
        this.reader.wrap((DirectBuffer)this.buffer, this.cursorOffset, this.bufferLength - this.cursorOffset);
        this.innerValueState = InnerValueState.Modify;
        ((BaseValue)this.innerValue).read(this.reader);
        this.oldInnerValueLength = ((BaseValue)this.innerValue).getEncodedLength();
    }

    private void flushAndResetInnerValue() {
        switch (this.innerValueState) {
            case Insert: {
                this.insertInnerValue();
                break;
            }
            case Modify: {
                this.updateInnerValue();
                break;
            }
        }
        this.resetInnerValue();
    }

    private void insertInnerValue() {
        int innerValueLength = ((BaseValue)this.innerValue).getEncodedLength();
        this.moveValuesRight(this.cursorOffset, innerValueLength);
        this.writeInnerValue();
        this.cursorOffset += innerValueLength;
        ++this.cursorIndex;
    }

    private void updateInnerValue() {
        int innerValueLength = ((BaseValue)this.innerValue).getEncodedLength();
        if (this.oldInnerValueLength < innerValueLength) {
            int difference = innerValueLength - this.oldInnerValueLength;
            this.moveValuesRight(this.cursorOffset + this.oldInnerValueLength, difference);
        } else if (this.oldInnerValueLength > innerValueLength) {
            int difference = this.oldInnerValueLength - innerValueLength;
            this.moveValuesLeft(this.cursorOffset + this.oldInnerValueLength, difference);
        }
        this.writeInnerValue();
    }

    private void writeInnerValue() {
        this.writer.wrap((MutableDirectBuffer)this.buffer, this.cursorOffset);
        ((BaseValue)this.innerValue).write(this.writer);
    }

    private void moveValuesLeft(int srcOffset, int removedLength) {
        if (srcOffset <= this.bufferLength) {
            int targetOffset = srcOffset - removedLength;
            int copyLength = this.bufferLength - srcOffset;
            this.buffer.putBytes(targetOffset, (DirectBuffer)this.buffer, srcOffset, copyLength);
        }
        this.bufferLength -= removedLength;
    }

    private void moveValuesRight(int srcOffset, int requiredLength) {
        if (srcOffset < this.bufferLength) {
            int targetOffset = srcOffset + requiredLength;
            int copyLength = this.bufferLength - srcOffset;
            this.buffer.putBytes(targetOffset, (DirectBuffer)this.buffer, srcOffset, copyLength);
        }
        this.bufferLength += requiredLength;
    }

    static enum InnerValueState {
        Uninitialized,
        Insert,
        Modify;

    }
}

