/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.property;

import io.zeebe.msgpack.MsgpackPropertyException;
import io.zeebe.msgpack.Recyclable;
import io.zeebe.msgpack.spec.MsgPackReader;
import io.zeebe.msgpack.spec.MsgPackWriter;
import io.zeebe.msgpack.value.BaseValue;
import io.zeebe.msgpack.value.StringValue;
import java.util.Objects;

public abstract class BaseProperty<T extends BaseValue>
implements Recyclable {
    protected StringValue key;
    protected T value;
    protected T defaultValue;
    protected boolean isSet;

    public BaseProperty(T value) {
        this("", value);
    }

    public BaseProperty(String keyString, T value) {
        this(keyString, value, null);
    }

    public BaseProperty(String keyString, T value, T defaultValue) {
        Objects.requireNonNull(keyString);
        Objects.requireNonNull(value);
        this.key = new StringValue(keyString);
        this.value = value;
        this.defaultValue = defaultValue;
    }

    public void set() {
        this.isSet = true;
    }

    @Override
    public void reset() {
        this.isSet = false;
        this.value.reset();
    }

    public boolean hasValue() {
        return this.isSet || this.defaultValue != null;
    }

    public StringValue getKey() {
        return this.key;
    }

    protected T resolveValue() {
        if (this.isSet) {
            return this.value;
        }
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        throw new MsgpackPropertyException(this.key, "Expected a value or default value to be specified, but has nothing");
    }

    public int getEncodedLength() {
        return this.key.getEncodedLength() + ((BaseValue)this.resolveValue()).getEncodedLength();
    }

    public void read(MsgPackReader reader) {
        ((BaseValue)this.value).read(reader);
        this.set();
    }

    public void write(MsgPackWriter writer) {
        T valueToWrite = this.value;
        if (!this.isSet) {
            valueToWrite = this.defaultValue;
        }
        if (valueToWrite == null) {
            throw new MsgpackPropertyException(this.key, "Expected a value or default value to be set before writing, but has nothing");
        }
        this.key.write(writer);
        ((BaseValue)valueToWrite).write(writer);
    }

    public void writeJSON(StringBuilder sb) {
        this.key.writeJSON(sb);
        sb.append(":");
        if (this.hasValue()) {
            ((BaseValue)this.resolveValue()).writeJSON(sb);
        } else {
            sb.append("\"NO VALID WRITEABLE VALUE\"");
        }
    }

    public int hashCode() {
        return Objects.hash(this.getKey(), this.value, this.defaultValue, this.isSet);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseProperty)) {
            return false;
        }
        BaseProperty that = (BaseProperty)o;
        return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.resolveValue(), that.resolveValue());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.key.toString());
        builder.append(" => ");
        builder.append(((BaseValue)this.value).toString());
        return builder.toString();
    }
}

