/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.value;

import io.zeebe.msgpack.spec.MsgPackReader;
import io.zeebe.msgpack.spec.MsgPackWriter;
import io.zeebe.msgpack.value.BaseValue;
import io.zeebe.msgpack.value.StringValue;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class BinaryValue
extends BaseValue {
    protected final MutableDirectBuffer data = new UnsafeBuffer(0L, 0);
    protected int length = 0;

    public BinaryValue() {
    }

    public BinaryValue(DirectBuffer initialValue, int offset, int length) {
        this.wrap(initialValue, offset, length);
    }

    @Override
    public void reset() {
        this.data.wrap(0L, 0);
        this.length = 0;
    }

    public void wrap(DirectBuffer buff) {
        this.wrap(buff, 0, buff.capacity());
    }

    public void wrap(DirectBuffer buff, int offset, int length) {
        if (length == 0) {
            this.data.wrap(0L, 0);
        } else {
            this.data.wrap(buff, offset, length);
        }
        this.length = length;
    }

    public void wrap(StringValue decodedKey) {
        this.wrap(decodedKey.getValue());
    }

    public DirectBuffer getValue() {
        return this.data;
    }

    @Override
    public void writeJSON(StringBuilder builder) {
        byte[] bytes = new byte[this.length];
        this.data.getBytes(0, bytes);
        builder.append("\"");
        builder.append(new String(Base64.getEncoder().encode(bytes), StandardCharsets.UTF_8));
        builder.append("\"");
    }

    @Override
    public void write(MsgPackWriter writer) {
        writer.writeBinary((DirectBuffer)this.data);
    }

    @Override
    public void read(MsgPackReader reader) {
        DirectBuffer buffer = reader.getBuffer();
        int stringLength = reader.readBinaryLength();
        int offset = reader.getOffset();
        reader.skipBytes(stringLength);
        this.wrap(buffer, offset, stringLength);
    }

    @Override
    public int getEncodedLength() {
        return MsgPackWriter.getEncodedBinaryValueLength((int)this.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BinaryValue)) {
            return false;
        }
        BinaryValue that = (BinaryValue)o;
        return this.length == that.length && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.length);
    }
}

