/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.dispatcher;

import io.zeebe.dispatcher.AtomicPosition;
import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.dispatcher.impl.PositionUtil;
import io.zeebe.dispatcher.impl.log.LogBuffer;
import io.zeebe.dispatcher.impl.log.LogBufferAppender;
import io.zeebe.dispatcher.impl.log.LogBufferDescriptor;
import io.zeebe.util.ByteValue;
import io.zeebe.util.EnsureUtil;
import io.zeebe.util.allocation.AllocatedBuffer;
import io.zeebe.util.allocation.BufferAllocators;
import io.zeebe.util.allocation.ExternallyAllocatedBuffer;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorScheduler;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.agrona.BitUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.CountersManager;

public class DispatcherBuilder {
    protected boolean allocateInMemory = true;
    protected ByteBuffer rawBuffer;
    protected String bufferFileName;
    protected int bufferSize = 0x40000000;
    protected int frameMaxLength;
    protected CountersManager countersManager;
    protected String dispatcherName;
    protected AtomicBuffer countersBuffer;
    protected ActorScheduler actorScheduler;
    protected String[] subscriptionNames;
    protected int mode = 1;
    protected int initialPartitionId = 0;

    public DispatcherBuilder(String dispatcherName) {
        this.dispatcherName = dispatcherName;
    }

    public DispatcherBuilder name(String name) {
        this.dispatcherName = name;
        return this;
    }

    public DispatcherBuilder allocateInBuffer(ByteBuffer rawBuffer) {
        this.allocateInMemory = false;
        this.rawBuffer = rawBuffer;
        return this;
    }

    public DispatcherBuilder allocateInFile(String fileName) {
        this.allocateInMemory = false;
        this.bufferFileName = fileName;
        return this;
    }

    public DispatcherBuilder bufferSize(ByteValue byteValue) {
        this.bufferSize = (int)byteValue.toBytes();
        return this;
    }

    public DispatcherBuilder actorScheduler(ActorScheduler actorScheduler) {
        this.actorScheduler = actorScheduler;
        return this;
    }

    public DispatcherBuilder frameMaxLength(int frameMaxLength) {
        this.frameMaxLength = frameMaxLength;
        return this;
    }

    public DispatcherBuilder initialPartitionId(int initialPartitionId) {
        EnsureUtil.ensureGreaterThanOrEqual((String)"initial partition id", (long)initialPartitionId, (long)0L);
        this.initialPartitionId = initialPartitionId;
        return this;
    }

    public DispatcherBuilder subscriptions(String ... subscriptionNames) {
        this.subscriptionNames = subscriptionNames;
        return this;
    }

    public DispatcherBuilder modePubSub() {
        this.mode = 1;
        return this;
    }

    public DispatcherBuilder modePipeline() {
        this.mode = 2;
        return this;
    }

    public Dispatcher build() {
        Objects.requireNonNull(this.actorScheduler, "Actor scheduler cannot be null.");
        int partitionSize = BitUtil.align((int)(this.bufferSize / 3), (int)8);
        AllocatedBuffer allocatedBuffer = this.initAllocatedBuffer(partitionSize);
        AtomicPosition publisherLimit = null;
        AtomicPosition publisherPosition = null;
        long initialPosition = PositionUtil.position(this.initialPartitionId, 0);
        publisherLimit = new AtomicPosition();
        publisherLimit.set(initialPosition);
        publisherPosition = new AtomicPosition();
        publisherPosition.set(initialPosition);
        LogBuffer logBuffer = new LogBuffer(allocatedBuffer, partitionSize, this.initialPartitionId);
        LogBufferAppender logAppender = new LogBufferAppender();
        int bufferWindowLength = partitionSize / 4;
        Dispatcher dispatcher = new Dispatcher(logBuffer, logAppender, publisherLimit, publisherPosition, bufferWindowLength, this.subscriptionNames, this.mode, this.dispatcherName);
        dispatcher.updatePublisherLimit();
        this.actorScheduler.submitActor((Actor)dispatcher);
        return dispatcher;
    }

    protected AllocatedBuffer initAllocatedBuffer(int partitionSize) {
        int requiredCapacity = LogBufferDescriptor.requiredCapacity(partitionSize);
        AllocatedBuffer allocatedBuffer = null;
        if (this.allocateInMemory) {
            allocatedBuffer = BufferAllocators.allocateDirect((int)requiredCapacity);
        } else if (this.rawBuffer != null) {
            if (this.rawBuffer.remaining() < requiredCapacity) {
                throw new RuntimeException("Buffer size below required capacity of " + requiredCapacity);
            }
            allocatedBuffer = new ExternallyAllocatedBuffer(this.rawBuffer);
        } else {
            File bufferFile = new File(this.bufferFileName);
            if (!bufferFile.exists()) {
                throw new RuntimeException("File " + this.bufferFileName + " does not exist");
            }
            allocatedBuffer = BufferAllocators.allocateMappedFile((int)requiredCapacity, (File)bufferFile);
        }
        return allocatedBuffer;
    }
}

